# Model Selection (Tiered, Model-Agnostic)

## Principle
Use the **cheapest capable tier** for the job. Escalate only when:
- the task repeatedly fails at a cheaper tier, or
- correctness materially matters (risk, finance, security), or
- the task requires deep synthesis/architecture.

Avoid naming specific models in guidance. Treat "model" as a **tier**.

---

## Tiers (conceptual)
- **Tier 1 (cheap / frequent):** routine formatting, lightweight summaries, single-script cron runs.
- **Tier 2 (general):** multi-file edits, orchestration, non-trivial debugging.
- **Tier 3 (deep):** architecture, risk analysis, complex planning.

---

## Escalation policy
- Start at Tier 1 for automation.
- Escalate to Tier 2 only after *observed* failure or clear complexity.
- Escalate to Tier 3 only with justification.

If you need user approval to change a global default, ask. Otherwise prefer local overrides per job.

---

## Anti-patterns
- Using Tier 3 for simple cron/heartbeat tasks.
- Re-running the same expensive analysis every schedule tick.
- Asking the user to choose a model for routine tasks (choose the cheapest tier that works).
