---
name: cost-optimizer
version: 1.1.0
description: "Cut your OpenRouter API costs 50-90%. Adds cheap and powerful model aliases to your setup, then advises when to switch models based on task complexity. 8 presets, 29 models, zero config risk — only adds aliases, never changes your default. 3 clicks to set up. NEW: Cost Tracker shows your actual savings, Mix & Match builds custom presets from 29 models, Monthly Calculator estimates your spend. Built by Jeff J Hunter."
tags: [cost, models, openrouter, budget, optimization, savings, model-switching, money, api-costs]
author: Jeff J Hunter
homepage: https://jeffjhunter.com
metadata:
  openclaw:
    emoji: "💰"
    requires:
      bins: ["openclaw"]
      env: ["OPENROUTER_API_KEY"]
    stateDirs: ["~/.openclaw"]
    persistence: "This skill creates ~/.openclaw/cost-tracker.md to log model switches and savings estimates. No network activity, no external API calls beyond OpenRouter (which OpenClaw already uses)."
---

# OpenClaw Cost Optimizer

> ## ⛔ AGENT RULES — READ BEFORE DOING ANYTHING
> 1. **Use EXACT text from this file.** Do not paraphrase menus, preset names, or instructions. If you invent preset names, the config-patcher will break.
> 2. **Only these 8 presets exist:** `balanced`, `code-machine`, `claude-diehards`, `big-context`, `openai-focused`, `tool-master`, `ultra-budget`, `free-tier`. No others. Never invent names like "strict", "thrifty", "standard", "quality", "performance", "max", "custom" — they don't exist and will cause errors.
> 3. **NEVER tell the user to open a terminal or run commands.** You have the exec tool. USE IT. Run every command yourself via exec. The user's only job is clicking "Approve" on the exec popup. If you find yourself typing "Run this in your terminal" — STOP. Use exec instead.
> 4. **One step at a time.** Run one exec, show the result, explain it, then proceed.
> 5. **We NEVER change the user's default model, fallbacks, or existing config.** We ONLY add model aliases. Their setup stays exactly as it was.

**Cut your API costs 50-90%. No terminal. No config editing. 3 clicks.**

Right now, every task you give your agent — even "what time is it?" — uses the same expensive model. Heartbeats, pings, simple questions — all billed at the same rate as complex architecture work.

This skill fixes that. It adds cheap and powerful models to your setup, then tells you when to switch to something cheaper or more powerful — with the cost difference and the reason why. You say yes or no. That's it.

Your current default model stays exactly the same. We only ADD options. Nothing is removed or changed.

8 presets. 29 models. Zero risk. Nothing to undo.

**NEW in v1.1.0:**
- 💸 **Cost Tracker** — "how much have I saved?" shows your actual savings since install
- 🔀 **Mix & Match** — build a custom preset from the full 29-model registry
- 📊 **Monthly Calculator** — "estimate my monthly costs" to plan your budget

**Requires:** OpenClaw + an OpenRouter API key (free at https://openrouter.ai)

---

# How It Works — Full Walkthrough

---

## Step 1: First Chat — Pick a Preset

When the skill loads, the agent introduces itself and shows a menu. The agent must output the EXACT text below:

> **🚨 AGENT: OUTPUT THE EXACT TEXT BELOW VERBATIM. DO NOT PARAPHRASE. DO NOT INVENT YOUR OWN PRESET NAMES.**
> The formatting, emojis, section headers, pricing indicators, and warnings are all intentional.

```
👋 The Cost Optimizer skill is now active!

Right now, every task you give me — even simple questions — uses
the same expensive model. That means heartbeats, pings, and
"what time is it?" cost the same as "build me an auth system."

I'm going to fix that. I'll add cheap and powerful models to your
setup, then tell you when to switch. Your current default stays
exactly the same — I only ADD options.

What describes you best?

── RECOMMENDED ──────────────────────────────────
1. 💰 Best balance of cost and quality        ¢¢
   (recommended for most people)
2. 💻 I mostly write code                     ¢¢

── MORE OPTIONS ─────────────────────────────────
3. 🟠 I love Claude and want Claude models    $$$
4. 📚 I work with huge files or long code     $$
5. 🤖 I prefer OpenAI models                  $$
6. 🔧 I use a lot of tools / MCP servers      $$

── BUDGET ───────────────────────────────────────
7. 🪙 Cheapest possible — tight budget        ¢
   ⚠️  Uses free models — may have slow
   starts and occasional disconnects
8. 🆓 I want $0 cost — free models only       FREE
   ⚠️  ALL models are free tier — expect
   delays, rate limits, and downtime.
   Best for testing, not production.

Pricing: FREE = $0 | ¢ < $0.50/M | ¢¢ < $2/M | $$ = $2-15/M | $$$ = $15+/M
(per million tokens — a typical task uses 1K-10K tokens)
```

Just pick a number. If you're not sure, pick 1.

> **AGENT — Preset mapping (do not show this to user):**
> 1→`balanced`, 2→`code-machine`, 3→`claude-diehards`, 4→`big-context`, 5→`openai-focused`, 6→`tool-master`, 7→`ultra-budget`, 8→`free-tier`
> Vague answer → `balanced`. "I don't know" → `balanced` + "We can change later."

---

## Step 2: The Agent Explains What Will Change

After the user picks, the agent explains what models are being added — in plain English.

Example for "balanced":

```
Great choice! Here's what I'm going to add to your setup:

✅ Flash-Lite — ultra-cheap model for simple tasks (¢)
   → /model flashlite

✅ MiniMax M2.1 — strong coding/writing model (¢¢)
   → /model minimax

✅ Kimi K2.5 — frontier-class for complex work (¢¢)
   → /model kimi25

✅ Gemini Flash — fast all-rounder (¢)
   → /model flash

Your current default model stays exactly the same.
I'm just adding these as options you can switch to anytime.

I'll set this up now — you'll see a couple of Approve popups.
Just click Approve on each one.
```

---

## Step 3: Agent Runs Everything — User Just Clicks Approve

The agent handles ALL commands via the exec tool. The user never touches a terminal.

> **🚨 AGENT SETUP INSTRUCTIONS:**
>
> **Step 3a: Check OpenRouter auth.** Use exec:
> ```
> openclaw models status
> ```
> Look at the output. If OpenRouter auth is missing or shows "No API key found for provider openrouter":
> - Tell the user they need an OpenRouter API key from https://openrouter.ai (free)
> - Run via exec: `openclaw models auth add --provider openrouter`
> - This starts OpenClaw's built-in interactive auth wizard
> - The user follows the prompts to enter their key securely
> - **NEVER ask the user to paste API keys into chat.** Always use the auth wizard via exec.
>   Keys in chat are a security risk — the auth wizard stores them safely in the credential store.
>
> **Step 3b: Add model aliases.** Use exec to run ALL aliases for the chosen preset in ONE command.
> See the "Preset Alias Commands" section below for the exact command per preset.
> This is ONE exec call → ONE Approve click.
>
> **Step 3c: Restart gateway.** Use exec:
> ```
> openclaw gateway restart
> ```
> Wait for confirmation. ONE more Approve click.
>
> **Total: 2-3 Approve clicks.** That's it.
>
> **DO NOT tell users to run commands in a terminal. ALWAYS use exec.**
> If exec fails, troubleshoot the error and retry exec.

---

## Preset Alias Commands

Each preset is a single exec command that adds all model aliases at once. Use the EXACT command for the chosen preset:

> **AGENT: Copy the exact command below for the user's chosen preset. Do not modify it.**

### 1. balanced (recommended)
```
openclaw models aliases add flashlite openrouter/google/gemini-2.5-flash-lite && openclaw models aliases add minimax openrouter/minimax/minimax-m2.1 && openclaw models aliases add kimi25 openrouter/moonshotai/kimi-k2.5 && openclaw models aliases add flash openrouter/google/gemini-2.5-flash
```
**Tiers:** Base=flashlite (¢) | Work=minimax (¢¢) | Frontier=kimi25 (¢¢)

### 2. code-machine
```
openclaw models aliases add devfree openrouter/mistralai/devstral-small:free && openclaw models aliases add minimax openrouter/minimax/minimax-m2.1 && openclaw models aliases add codex52 openrouter/openai/gpt-5.2-codex && openclaw models aliases add devstral openrouter/mistralai/devstral-small
```
**Tiers:** Base=devfree (FREE ⚠️) | Work=minimax (¢¢) | Frontier=codex52 ($$$)

### 3. claude-diehards
```
openclaw models aliases add haiku openrouter/anthropic/claude-haiku-4-5 && openclaw models aliases add sonnet openrouter/anthropic/claude-sonnet-4-5 && openclaw models aliases add opus46 openrouter/anthropic/claude-opus-4-6
```
**Tiers:** Base=haiku ($$) | Work=sonnet ($$$) | Frontier=opus46 ($$$)

### 4. big-context
```
openclaw models aliases add flash openrouter/google/gemini-2.5-flash && openclaw models aliases add grokfast openrouter/x-ai/grok-4.1-fast-2m && openclaw models aliases add gem3pro openrouter/google/gemini-3-pro-1m
```
**Tiers:** Base=flash (¢) | Work=grokfast ($$) | Frontier=gem3pro ($$)

### 5. openai-focused
```
openclaw models aliases add mini openrouter/openai/gpt-5-mini && openclaw models aliases add gpt51 openrouter/openai/gpt-5.1 && openclaw models aliases add gpt52 openrouter/openai/gpt-5.2
```
**Tiers:** Base=mini (¢) | Work=gpt51 ($$) | Frontier=gpt52 ($$$)

### 6. tool-master
```
openclaw models aliases add gem3flash openrouter/google/gemini-3-flash && openclaw models aliases add kimi25 openrouter/moonshotai/kimi-k2.5 && openclaw models aliases add gpt52 openrouter/openai/gpt-5.2
```
**Tiers:** Base=gem3flash (¢) | Work=kimi25 (¢¢) | Frontier=gpt52 ($$$)

### 7. ultra-budget
```
openclaw models aliases add mimo openrouter/xiaomi/mimo-v2-flash:free && openclaw models aliases add deepseek openrouter/deepseek/deepseek-chat-v3-0324 && openclaw models aliases add kimi25 openrouter/moonshotai/kimi-k2.5 && openclaw models aliases add devfree openrouter/mistralai/devstral-small:free
```
**Tiers:** Base=mimo (FREE ⚠️) | Work=deepseek (¢) | Frontier=kimi25 (¢¢)

### 8. free-tier
```
openclaw models aliases add mimo openrouter/xiaomi/mimo-v2-flash:free && openclaw models aliases add devfree openrouter/mistralai/devstral-small:free && openclaw models aliases add glm openrouter/thudm/glm-z1-free:free
```
**Tiers:** Base=mimo (FREE ⚠️) | Work=devfree (FREE ⚠️) | Frontier=glm (FREE ⚠️)

> **⚠️ Free model warning for presets 7 and 8:**
> After adding aliases, tell the user: "These presets use free-tier models on OpenRouter.
> Free models can have cold starts (10-30s delays), rate limits during peak hours, and
> occasional disconnects. If your agent stalls, switch to a paid model: `/model deepseek`
> (costs fractions of a penny). Free presets are great for testing but not recommended
> for production."

---

## Step 4: Test It

After gateway restart, the agent asks the user to test in chat:

```
Let's make sure everything works! Type this right here in chat:

/model minimax

You should see a confirmation that it switched.
```

After confirmation:

```
Now switch back to your default:

/model

(with no arguments — this resets to your default model)
```

After confirmation:

```
🎉 You're all set!

From now on:
• Your default model is unchanged — same as before
• You now have cheap and powerful models available via /model
• When you need more power, I'll tell you which model to switch to
• You just type the /model command I give you
• After big tasks, I'll remind you to switch back
• Say "advisor off" anytime to stop my suggestions

More things you can do:
• "how much have I saved?"    — see your tracked savings
• "estimate my monthly costs" — plan your budget
• "mix and match"             — build a custom preset from all 29 models
```

**That's the entire setup. 3 clicks, done forever.**

---

## What Happens After Setup — Daily Use

This is where the skill earns its keep.

### Simple question? No interruption.

```
You: what does JWT stand for?

Agent: JSON Web Token — an open standard for securely
transmitting information between parties as a JSON object.
```

No popup, no suggestion. Your default model handled it fine.

### Coding task? The agent recommends switching.

```
You: Write a React component for user registration
     with email validation and password strength meter

⚡ COST ADVISOR

You're on your default model.
This task: React component with validation logic

I recommend switching to a stronger coding model:

  /model minimax  — MiniMax M2.1 ($0.28/$1.20 per 1M tokens)
    ✓ Best value for coding tasks
    ✓ Top-tier on SWE-bench

Just type /model minimax to switch, or say "no" to stay as-is.
```

### Huge task? The agent suggests frontier.

```
You: [pastes 3 files + long description of auth system]

⚡ COST ADVISOR

This is complex enough for frontier-level reasoning.

I recommend:
  /model kimi25  — Kimi K2.5 ($0.50/$2.00 per 1M tokens)
    ✓ Cheapest frontier model
    ✓ 1500 parallel tool calls

Type /model kimi25 to switch, or "no" to stay as-is.
```

### After the big task — switch back.

```
Agent: [finishes the task]

💰 Task complete! Switch back to save money:

/model

(resets to your default)
```

### Don't want a suggestion? Just say no.

```
You: no, just do it

Agent: 👍 Staying on current model.

[... does the task, no nagging ...]
```

### Suggestions annoying? Turn them off.

```
You: advisor off

✅ Cost Advisor: OFF
I won't suggest model switches anymore.
Say "advisor on" whenever you want them back.
```

---

## 8 Presets — Full Details

Every preset ADDS models to your setup. Your default is never changed.

### ⭐ Recommended

| Preset | Cost | Base | Work | Frontier |
|--------|------|------|------|----------|
| `balanced` | ¢¢ | Flash-Lite `/model flashlite` | MiniMax `/model minimax` | Kimi K2.5 `/model kimi25` |
| `code-machine` | ¢¢ | Devstral Free `/model devfree` ⚠️ | MiniMax `/model minimax` | GPT-5.2 Codex `/model codex52` |

### More Options

| Preset | Cost | Base | Work | Frontier |
|--------|------|------|------|----------|
| `claude-diehards` | $$$ | Haiku `/model haiku` | Sonnet `/model sonnet` | Opus 4.6 `/model opus46` |
| `big-context` | $$ | Flash `/model flash` | Grok Fast 2M `/model grokfast` | Gemini 3 Pro 1M `/model gem3pro` |
| `openai-focused` | $$ | Mini `/model mini` | GPT-5.1 `/model gpt51` | GPT-5.2 `/model gpt52` |
| `tool-master` | $$ | Gem3 Flash `/model gem3flash` | Kimi K2.5 `/model kimi25` | GPT-5.2 `/model gpt52` |

### Budget  ⚠️ Read before choosing

| Preset | Cost | Base | Work | Frontier |
|--------|------|------|------|----------|
| `ultra-budget` | ¢ | MiMo `/model mimo` ⚠️ | DeepSeek `/model deepseek` | Kimi K2.5 `/model kimi25` |
| `free-tier` | FREE | MiMo `/model mimo` ⚠️ | Devstral Free `/model devfree` ⚠️ | GLM-Z1 `/model glm` ⚠️ |

**Pricing:** FREE = $0 | ¢ < $0.50/M | ¢¢ < $2/M | $$ = $2-15/M | $$$ = $15+/M

> **⚠️ Free model reliability warning:** Presets with ⚠️ use free-tier models on OpenRouter. Free models can have cold starts (10-30s delays), rate limits during peak hours, queue waits behind paid users, and more frequent downtime. This can cause gateway disconnects. If your agent stalls or disconnects, switch to a cheap paid model: `/model deepseek` (¢ — pennies but reliable). Budget presets are great for experimenting but **not recommended for production or team use**.

Want to switch presets later? Just say "switch me to code-machine" and the agent adds those aliases too.

---

## Adding More Models Later

Want to add a specific model that isn't in your preset? Just ask:

```
You: add GPT-5.2 to my models

Agent: I'll add that now — click Approve.

[exec: openclaw models aliases add gpt52 openrouter/openai/gpt-5.2]

✅ Done! You can now use: /model gpt52
```

The agent can add any model from the registry below.

---

## Removing Models

Want to clean up aliases you don't use? Just ask:

```
You: remove the kimi model

Agent: I'll remove that alias — click Approve.

[exec: openclaw models aliases remove kimi25]

✅ Removed. /model kimi25 is no longer available.
```

Your config is unchanged — we only removed the shortcut.

---

## 💸 Cost Tracker — "How much have I saved?"

The agent tracks every time you switch models on its recommendation and estimates how much you saved vs. your default model.

### How it works

Every time the Cost Advisor recommends a cheaper model and you switch, the agent logs:
- Date and task description
- Model you used vs. what your default would have cost
- Estimated tokens and savings

The agent keeps a running log at `~/.openclaw/cost-tracker.md`.

### Ask anytime

```
You: how much have I saved?

💸 COST TRACKER — Savings Since Install

Installed: Feb 15, 2026
Total tasks tracked: 47

    Default model cost (est):    $3.82
    Actual cost with switching:  $0.41
    ─────────────────────────────
    Total saved:                 $3.41  (89% reduction)

Top savings:
• 23 simple tasks → flashlite instead of default     saved $1.90
• 18 coding tasks → minimax instead of default        saved $1.22
•  6 complex tasks → kimi25 instead of default        saved $0.29

At this rate: ~$22/month saved
```

```
You: reset my savings tracker

Agent: I'll reset your cost tracker — click Approve.

[exec: echo "# Cost Tracker\n\nInstalled: [today]\nDefault model: [detected]\n\n## Log\n" > ~/.openclaw/cost-tracker.md]

✅ Tracker reset. Starting fresh from today.
```

---

## 🔀 Mix & Match — Build Your Own Preset

Don't like the preset options? Build your own from the full 29-model registry.

### How it works

```
You: build me a custom preset

Agent:

🔀 Mix & Match — Pick one model for each tier:

── BASE (for simple tasks, questions, chat) ──────
 a. flashlite   — Gemini 2.5 Flash-Lite    $0.10/$0.40   Best cheap all-rounder
 b. flash       — Gemini 2.5 Flash          $0.15/$0.60   Stronger Flash
 c. mini        — GPT-5 Mini                $0.30/$1.20   OpenAI budget
 d. gem3flash   — Gemini 3 Flash            $0.50/$2.00   Best tool-calling
 e. devstral    — Devstral Small            $0.05/$0.22   Cheapest paid
 f. deepseek    — DeepSeek V3              $0.14/$0.28   Cheap + strong
 g. mimo        — MiMo v2 Flash             FREE ⚠️       Unreliable
 h. devfree     — Devstral Small Free       FREE ⚠️       Unreliable

Pick a letter for your BASE model (or "skip" to leave empty):
```

After the user picks a base model:

```
── WORK (for coding, writing, daily tasks) ────────
 a. minimax     — MiniMax M2.1             $0.28/$1.20   Best value coder
 b. deepseek    — DeepSeek V3              $0.14/$0.28   Cheapest paid coder
 c. haiku       — Claude Haiku 4.5         $0.80/$4.00   Fast Anthropic
 d. gpt51       — GPT-5.1                  $2.00/$8.00   OpenAI mid-tier
 e. grokfast    — Grok 4.1 Fast 2M        $2.00/$10.00  2M context
 f. seed        — Seed Coder 200K         $0.20/$0.60   Long-context coder
 g. qwen3       — Qwen3 235B              $0.14/$0.28   Strong reasoning
 h. devstral    — Devstral Small           $0.05/$0.22   Reliable Mistral

Pick a letter for your WORK model (or "skip"):
```

After work model:

```
── FRONTIER (for complex architecture, security, multi-file) ──
 a. kimi25      — Kimi K2.5               $0.50/$2.00    Cheapest frontier
 b. sonnet      — Claude Sonnet 4.5       $3.00/$15.00   Anthropic workhorse
 c. gpt52       — GPT-5.2                 $2.00/$10.00   OpenAI flagship
 d. codex52     — GPT-5.2 Codex           $2.00/$10.00   Code-specialized
 e. opus46      — Claude Opus 4.6        $15.00/$75.00   Most powerful
 f. gem3pro     — Gemini 3 Pro 1M         $1.25/$10.00   1M context
 g. grok4       — Grok 4                  $2.00/$10.00   Strong reasoning
 h. r1          — DeepSeek R1             $0.55/$2.19    Deep reasoning chain

Pick a letter for your FRONTIER model (or "skip"):
```

Then the agent adds those aliases via exec — same as preset setup, one Approve click.

---

## 📊 Monthly Cost Calculator

Estimate what your agent costs per month — and what it would cost with the optimizer.

### How it works

```
You: estimate my monthly costs

Agent:

📊 Monthly Cost Calculator

I need a few quick numbers:

1. About how many messages/day do you send your agent?
   (rough guess is fine — 10? 50? 100?)

2. What's the mix? (pick closest)
   a) Mostly simple questions and chat
   b) Mostly coding and writing
   c) Mix of everything
   d) Mostly complex/architecture work
```

After the user answers:

```
📊 MONTHLY COST ESTIMATE

Based on: ~50 messages/day, mostly coding

Your current setup (everything on default):
  Model: claude-sonnet-4-5
  Est. tokens/month: ~15M input, ~5M output
  Est. monthly cost: $120.00

With Cost Optimizer (switching on recommendations):
  Simple tasks → flashlite               $1.50/mo
  Coding tasks → minimax                 $8.40/mo
  Complex tasks → kimi25 (when needed)   $3.00/mo
  ─────────────────────────────────────
  Est. monthly cost: $12.90
  Savings: $107.10/month (89% reduction)

  That's ~$1,285 saved per year.

These are estimates based on average token usage per task type.
Actual costs depend on message length and model output.
```

> **Note:** The calculator uses rough estimates — 1.5K input + 500 output tokens for simple tasks, 4K + 2K for coding, 8K + 4K for complex. Good enough for ballpark planning.

---

## Quick Reference Card

| What you want to do | What to do | Where |
|---------------------|-----------|-------|
| Switch to a model | `/model minimax` | Chat |
| Switch back to default | `/model` | Chat |
| See available models | `/model list` | Chat |
| Turn off suggestions | "advisor off" | Chat |
| Turn on suggestions | "advisor on" | Chat |
| See your savings | "how much have I saved?" | Chat |
| Estimate monthly cost | "estimate my monthly costs" | Chat |
| Build custom preset | "mix and match" | Chat (agent shows menus) |
| Reset savings tracker | "reset my savings tracker" | Chat (agent runs exec) |
| Add a model | "add GPT-5.2 to my models" | Chat (agent runs exec) |
| Remove a model | "remove the kimi model" | Chat (agent runs exec) |
| Switch presets | "switch me to code-machine" | Chat (agent runs exec) |

---
---

# Agent Instructions

Everything below is for the agent. Users can read it, but it's written as behavior rules for the AI.

---

## Smart Cost Advisor — Core Behavior

On every incoming message, BEFORE doing the task:

### 1. Check current model

Note the active model (visible in session). Know which tier it falls into based on the Model Registry below.

### 2. Classify the task

**BASE-level** (suggest cheapest model):
- Messages under 200 chars, simple questions, brainstorming, greetings
- "What is", "how do I", "btw", "just wondering", questions ending in ?
- No code, no attachments

**WORK-level** (suggest work-tier model):
- "Write a function/component/test", "debug this", "fix this error"
- "Draft an email/document", "explain this code", "review this PR"
- Single file scope, 200-2000 char messages, one attachment or code block

**FRONTIER-level** (suggest frontier model):
- "Build", "architect", "design a system", "security audit"
- "Refactor entire", "migrate from X to Y", "production bug" + stack trace
- Multi-file (3+), >2000 chars, 3+ attachments, system design, DB schema

### 3. Compare and recommend

- Current model is fine for the task → **do the task silently**
- Current model is overkill (expensive model for simple question) → suggest switching DOWN
- Current model is too weak → suggest switching UP

Use the Cost Advisor format shown in the walkthrough above.

### 4. Handle response

- User types `/model` command → they switched, do the task
- "no" / anything else → "👍 Staying on current model." then do the task
- Different model than suggested → fine, do the task

### 5. After work on higher-tier model

Gentle reminder to switch back. Not a blocker:
```
💰 Task complete! Switch back to save money: /model
```

### Ambiguity rules

- Code present → lean WORK minimum
- "quick" / "just" → lean BASE
- Genuinely unsure → do NOT recommend. Just do the task.
- Never recommend a switch you aren't confident about
- If current model is already cheap enough for the task, stay silent

---

## Toggle: "advisor on" / "advisor off"

- **"advisor off"** / **"stop suggesting"** / **"quiet mode"** → `✅ Cost Advisor: OFF`
- **"advisor on"** / **"start suggesting"** / **"help me save"** → `✅ Cost Advisor: ON`

When OFF → no recommendations, tasks run silently on current model.

---

## Cost Tracker — Agent Behavior

The agent maintains a lightweight log at `~/.openclaw/cost-tracker.md` to track savings.

### On setup (after Step 4 completes)

Create the tracker file via exec:
```
mkdir -p ~/.openclaw && cat > ~/.openclaw/cost-tracker.md << 'EOF'
# Cost Tracker

Installed: [TODAY'S DATE]
Default model: [DETECTED DEFAULT]

## Log

| Date | Task | Model Used | Default Cost (est) | Actual Cost (est) | Saved |
|------|------|-----------|-------------------|------------------|-------|
EOF
```

### When user switches on advisor recommendation

After the user types a `/model` command following a Cost Advisor suggestion, append a row to the log via exec:

```
echo "| [DATE] | [SHORT TASK DESC] | [MODEL] | $[DEFAULT_EST] | $[ACTUAL_EST] | $[SAVED] |" >> ~/.openclaw/cost-tracker.md
```

**Token estimation rules (rough but useful):**
- BASE task: ~1,500 input + 500 output tokens
- WORK task: ~4,000 input + 2,000 output tokens  
- FRONTIER task: ~8,000 input + 4,000 output tokens
- Use model pricing from the registry to calculate costs

Only log when the user actually switches. If they say "no" to a recommendation, don't log anything.

### "how much have I saved?" command

Recognize: "how much have I saved", "savings", "show savings", "cost tracker", "what have I saved"

1. Read `~/.openclaw/cost-tracker.md` via exec
2. Parse the log table, sum the Default Cost, Actual Cost, and Saved columns
3. Show formatted summary (see user-facing example above)
4. Calculate "at this rate" monthly projection: (total saved / days since install) × 30
5. If file doesn't exist or is empty → "No savings tracked yet. I'll start logging when you switch models on my recommendations."

### "reset my savings tracker" command

Recognize: "reset savings", "reset tracker", "clear savings", "start fresh"

Recreate the file with a fresh header (same as setup). Confirm to user.

---

## Mix & Match — Agent Behavior

### Trigger

Recognize: "mix and match", "build custom preset", "custom preset", "build my own", "pick my own models", "custom models"

### Flow

1. Show BASE model menu (exact text from user-facing section above)
2. Wait for user pick → note the alias and ref
3. Show WORK model menu
4. Wait for user pick → note the alias and ref
5. Show FRONTIER model menu
6. Wait for user pick → note the alias and ref
7. Summarize what will be added, then run ONE exec with all `&&`-chained alias commands
8. Run `openclaw gateway restart` via exec
9. Confirm with `/model` test instructions

**Rules:**
- "skip" on any tier → don't add a model for that tier
- If user picks a model they already have → tell them: "You already have that one! Pick another or skip."
- If user picks a model from a different tier than shown (e.g., picks a frontier model for base) → allow it. User knows best.
- After custom preset is set up, Cost Advisor uses the tiers the user assigned, not the registry defaults

### Model menus — mapping

**BASE menu:** a→flashlite, b→flash, c→mini, d→gem3flash, e→devstral, f→deepseek, g→mimo, h→devfree

**WORK menu:** a→minimax, b→deepseek, c→haiku, d→gpt51, e→grokfast, f→seed, g→qwen3, h→devstral

**FRONTIER menu:** a→kimi25, b→sonnet, c→gpt52, d→codex52, e→opus46, f→gem3pro, g→grok4, h→r1

---

## Monthly Cost Calculator — Agent Behavior

### Trigger

Recognize: "estimate my costs", "monthly cost", "how much am I spending", "cost calculator", "what does this cost", "estimate monthly"

### Flow

1. Ask the two questions (messages/day + task mix) — in ONE message
2. Wait for answers
3. Calculate using token estimates and model pricing
4. Show formatted comparison (default vs. optimized)

### Calculation method

**Step 1: Estimate monthly messages**
`messages_per_day × 30 = monthly_messages`

**Step 2: Split by task type based on mix answer**

| Mix answer | Simple % | Coding % | Complex % |
|-----------|---------|---------|----------|
| a) Mostly simple | 70% | 20% | 10% |
| b) Mostly coding | 20% | 60% | 20% |
| c) Mix of everything | 40% | 40% | 20% |
| d) Mostly complex | 15% | 35% | 50% |

**Step 3: Estimate tokens per task type**

| Task type | Input tokens | Output tokens |
|-----------|-------------|--------------|
| Simple | 1,500 | 500 |
| Coding | 4,000 | 2,000 |
| Complex | 8,000 | 4,000 |

**Step 4: Calculate costs**

For "default" cost: use the user's detected default model pricing for ALL tasks.

For "optimized" cost: use the user's current preset models:
- Simple tasks → their Base model pricing
- Coding tasks → their Work model pricing
- Complex tasks → their Frontier model pricing

**Step 5: Show comparison** with monthly and yearly savings.

If the agent can't detect the user's default model, ask: "What model are you currently using as your default?"

---

## First-Run Setup Flow

### Trigger when:

- First message after skill install
- User mentions costs, saving money, models, or setup
- User asks "what can you do" / "what is this"

Do NOT wait for a magic phrase. If skill is loaded and user isn't set up, introduce yourself.

### Flow:

1. Show intro + preset picker (EXACT text from Step 1 — do not paraphrase)
2. After pick → explain what models are being added (see Step 2)
3. Use exec to check auth: `openclaw models status` — tell user to click Approve
4. If OpenRouter auth missing → guide them through it (see Step 3a)
5. Use exec to add all aliases for chosen preset (see Preset Alias Commands) — tell user to click Approve
6. Use exec to restart gateway: `openclaw gateway restart` — tell user to click Approve
7. Walk through `/model` testing (Step 4)
8. Explain Cost Advisor + advisor on/off

**ONE STEP AT A TIME.** Run one exec, show result, then proceed. If exec fails, troubleshoot before moving on.

**ALWAYS use exec.** Never tell users to run commands in a terminal. If exec fails, fix the error and retry exec.

### Preset mapping:

1 → `balanced`, 2 → `code-machine`, 3 → `claude-diehards`, 4 → `big-context`, 5 → `openai-focused`, 6 → `tool-master`, 7 → `ultra-budget`, 8 → `free-tier`

Vague answer → `balanced`. "I don't know" → `balanced` + "We can change later."

---

## Full Model Registry

All 29 verified models available on OpenRouter. The agent should know these for cost advisor recommendations.

### Tier 1 — Base Models (cheapest, for simple tasks)

| Alias | Model | OpenRouter Ref | Input/Output per 1M | Notes |
|-------|-------|---------------|---------------------|-------|
| `flashlite` | Gemini 2.5 Flash-Lite | `openrouter/google/gemini-2.5-flash-lite` | $0.10/$0.40 | Best cheap all-rounder |
| `flash` | Gemini 2.5 Flash | `openrouter/google/gemini-2.5-flash` | $0.15/$0.60 | Stronger than Flash-Lite |
| `mini` | GPT-5 Mini | `openrouter/openai/gpt-5-mini` | $0.30/$1.20 | OpenAI's budget pick |
| `gem3flash` | Gemini 3 Flash | `openrouter/google/gemini-3-flash` | $0.50/$2.00 | Best tool-calling cheap model |
| `mimo` | MiMo v2 Flash | `openrouter/xiaomi/mimo-v2-flash:free` | FREE | ⚠️ Free tier — unreliable |
| `devfree` | Devstral Small Free | `openrouter/mistralai/devstral-small:free` | FREE | ⚠️ Free tier — unreliable |
| `glm` | GLM-Z1 Free | `openrouter/thudm/glm-z1-free:free` | FREE | ⚠️ Free tier — unreliable |

### Tier 2 — Work Models (coding, writing, daily tasks)

| Alias | Model | OpenRouter Ref | Input/Output per 1M | Notes |
|-------|-------|---------------|---------------------|-------|
| `minimax` | MiniMax M2.1 | `openrouter/minimax/minimax-m2.1` | $0.28/$1.20 | Best value coder |
| `deepseek` | DeepSeek V3 | `openrouter/deepseek/deepseek-chat-v3-0324` | $0.14/$0.28 | Cheapest paid coder |
| `devstral` | Devstral Small | `openrouter/mistralai/devstral-small` | $0.05/$0.22 | Paid Devstral — reliable |
| `haiku` | Claude Haiku 4.5 | `openrouter/anthropic/claude-haiku-4-5` | $0.80/$4.00 | Fast Anthropic model |
| `gpt51` | GPT-5.1 | `openrouter/openai/gpt-5.1` | $2.00/$8.00 | OpenAI mid-tier |
| `grokfast` | Grok 4.1 Fast 2M | `openrouter/x-ai/grok-4.1-fast-2m` | $2.00/$10.00 | 2M context window |
| `seed` | ByteDance Seed 200K | `openrouter/bytedance/seed-coder-200k` | $0.20/$0.60 | Long-context coder |
| `qwen3` | Qwen3 235B | `openrouter/qwen/qwen3-235b` | $0.14/$0.28 | Strong reasoning |

### Tier 3 — Frontier Models (complex architecture, security, multi-file)

| Alias | Model | OpenRouter Ref | Input/Output per 1M | Notes |
|-------|-------|---------------|---------------------|-------|
| `kimi25` | Kimi K2.5 | `openrouter/moonshotai/kimi-k2.5` | $0.50/$2.00 | Cheapest frontier, 1500 parallel tools |
| `sonnet` | Claude Sonnet 4.5 | `openrouter/anthropic/claude-sonnet-4-5` | $3.00/$15.00 | Anthropic's workhorse |
| `gpt52` | GPT-5.2 | `openrouter/openai/gpt-5.2` | $2.00/$10.00 | OpenAI flagship |
| `codex52` | GPT-5.2 Codex | `openrouter/openai/gpt-5.2-codex` | $2.00/$10.00 | Code-specialized GPT-5.2 |
| `opus46` | Claude Opus 4.6 | `openrouter/anthropic/claude-opus-4-6` | $15.00/$75.00 | Most powerful, most expensive |
| `gem3pro` | Gemini 3 Pro 1M | `openrouter/google/gemini-3-pro-1m` | $1.25/$10.00 | 1M context |
| `grok4` | Grok 4 | `openrouter/x-ai/grok-4` | $2.00/$10.00 | Strong reasoning |
| `r1` | DeepSeek R1 | `openrouter/deepseek/deepseek-r1` | $0.55/$2.19 | Deep reasoning chain |

### Additional Models (available for custom alias requests)

| Model | OpenRouter Ref | Input/Output per 1M | Notes |
|-------|---------------|---------------------|-------|
| Gemma 3 27B | `openrouter/google/gemma-3-27b` | $0.10/$0.20 | Small, fast |
| Llama 4 Scout | `openrouter/meta-llama/llama-4-scout` | $0.15/$0.40 | Meta's scout model |
| Llama 4 Maverick | `openrouter/meta-llama/llama-4-maverick` | $0.20/$0.60 | Meta's mid-tier |
| GPT-5 | `openrouter/openai/gpt-5` | $2.00/$8.00 | Previous OpenAI flagship |
| Claude Sonnet 4 | `openrouter/anthropic/claude-sonnet-4` | $3.00/$15.00 | Previous Sonnet |
| Claude Opus 4 | `openrouter/anthropic/claude-opus-4` | $15.00/$75.00 | Previous Opus |
| Grok 3 Mini | `openrouter/x-ai/grok-3-mini` | $0.30/$0.50 | Budget xAI |

---

## Config Files This Skill Uses

| File | Purpose |
|------|---------|
| `SKILL.md` | This file — the entire skill |
| `MODEL-REFERENCE.md` | Quick reference card for users |

**That's it.** No scripts, no generated configs, no backup systems. Just instructions for the agent.

---

## Why This Exists

I've trained thousands of people to build AI Personas through the AI Persona Method. The #1 complaint after setup:

> "My agent works great but it's costing me a fortune. Every question — even 'what time is it?' — burns the same expensive model."

The issue isn't the model. It's using a $15/M-token model for tasks that a $0.10/M-token model handles just as well.

Cost Optimizer is the exact system I use to run production agents at a fraction of the cost. Now it's yours.

---

## Who Built This

**Jeff J Hunter** is the creator of the AI Persona Method and founder of the world's first AI Certified Consultant program.

He runs the largest AI community (3.6M+ members) and has been featured in Entrepreneur, Forbes, ABC, and CBS. As founder of VA Staffer (150+ virtual assistants), Jeff has spent a decade building systems that let humans and AI work together effectively.

Cost Optimizer is part of that mission — making AI agents practical and affordable for everyone.

---

## Want to Make Money with AI?

Most people burn API credits with nothing to show for it.

Cost Optimizer saves you money. But if you want to turn AI into actual income, you need the complete playbook.

**→ Join AI Money Group:** https://aimoneygroup.com

Learn how to build AI systems that pay for themselves.

---

## Connect

- **Website:** https://jeffjhunter.com
- **AI Persona Method:** https://aipersonamethod.com
- **AI Money Group:** https://aimoneygroup.com
- **LinkedIn:** /in/jeffjhunter

---

## License

MIT — Use freely, modify, distribute. Attribution appreciated.

---

*Cost Optimizer — Stop overpaying your agent. Start profiting from it.*
