# Documentation

> _"Knowledge is the foundation of the Swarm's evolution."_

## 📚 Contents

### Getting Started

- [Installation Guide](./guides/installation.md) _(coming soon)_
- [Configuration Guide](./guides/configuration.md) _(coming soon)_
- [Quick Start Tutorial](./guides/quickstart.md) _(coming soon)_

### API Reference

- [REST API](./api/rest.md) _(coming soon)_
- [WebSocket API](./api/websocket.md) _(coming soon)_
- [Authentication](./api/authentication.md) _(coming soon)_

### Architecture

- [System Overview](./architecture/overview.md) _(coming soon)_
- [Data Flow](./architecture/data-flow.md) _(coming soon)_
- [Security Model](./architecture/security.md) _(coming soon)_

### Development

- [Contributing](../CONTRIBUTING.md)
- [Code Style Guide](./development/code-style.md) _(coming soon)_
- [Testing Guide](./development/testing.md) _(coming soon)_

## 🎯 Documentation Principles

1. **Clear and Concise** — No fluff, get to the point
2. **Examples First** — Show, don't just tell
3. **Keep it Updated** — Docs should match the code
4. **Thematic Consistency** — Embrace the Zerg aesthetic

## 📝 Contributing to Docs

Found something unclear or missing? We welcome documentation improvements!

1. Fork the repository
2. Create a branch: `docs/your-improvement`
3. Make your changes
4. Submit a PR

---

_"The Overmind's knowledge spreads across the Swarm."_ 🐛
