# Code Search Skill — 需求文档

## 1. 背景

OpenClaw 当前缺少专用的代码搜索工具。每次需要搜索文件内容或查找文件时，只能通过 `exec` 工具手动拼 shell 命令（grep、find、ls），效率低、输出格式不统一、对 AI 不友好。

对标项目 OpenCode 内置了 3 个专用搜索工具：
- **grep** — 按内容搜索文件，支持正则，结果按修改时间排序
- **glob** — 按文件名模式匹配搜索
- **ls** — 递归列出目录结构

## 2. 目标

提供一个 Code Search Skill，封装现代 CLI 工具（ripgrep、fd、tree），为 AI Agent 提供结构化、高效的代码搜索能力。

## 3. 核心需求

### 3.1 内容搜索（grep）
- **输入**：搜索模式（正则或字面量）、目标路径（可选）、文件类型过滤（可选）、最大结果数（可选）
- **输出**：匹配的文件路径、行号、匹配行内容，按文件修改时间倒序
- **要求**：
  - 默认忽略 .git、node_modules、__pycache__、.venv 等目录
  - 默认忽略二进制文件
  - 支持字面量搜索模式（自动转义特殊字符）
  - 结果上限默认 100 条，可配置
  - 输出格式对 AI 友好（结构化文本）

### 3.2 文件搜索（glob）
- **输入**：文件名模式（glob 或正则）、目标路径（可选）、文件类型过滤（可选）
- **输出**：匹配的文件完整路径列表，按修改时间倒序
- **要求**：
  - 默认忽略同上隐藏/缓存目录
  - 结果上限默认 200 条
  - 支持常见 glob 语法（*.go、*.{ts,tsx}、**/test/**）

### 3.3 目录结构（ls/tree）
- **输入**：目标路径（可选）、最大深度（可选）
- **输出**：树形目录结构
- **要求**：
  - 默认深度 3 层
  - 默认忽略 .git、node_modules 等
  - 显示文件大小（可选）

## 4. 非功能需求

- **性能**：单次搜索应在 5 秒内返回结果（中等规模项目 <100k 文件）
- **安全**：只读操作，不修改任何文件
- **依赖**：ripgrep (rg)、fd-find (fd)、tree；Skill 启动时检查依赖是否安装，缺失时给出安装指引
- **兼容**：Linux x86_64（当前服务器环境）

## 5. 不做什么

- 不做代码语义分析（那是 LSP Skill 的事）
- 不做跨仓库搜索（那是 Sourcegraph Skill 的事）
- 不做文件修改（只读）
- 不做索引构建（依赖 rg/fd 的实时搜索能力）

## 6. 验收标准

1. `grep "func main" --path /root/.openclaw/workspace/opencode` 能在 3 秒内返回所有包含 "func main" 的文件
2. `glob "*.go" --path /root/.openclaw/workspace/opencode` 能列出所有 Go 文件
3. `tree --path /root/.openclaw/workspace/opencode --depth 2` 能展示项目结构
4. 缺少 rg/fd 时，给出明确的安装提示而不是报错崩溃
5. SKILL.md 描述准确，Agent 能根据描述正确选择使用此 Skill
