---
name: openclaw-cli
description: Operate and troubleshoot the OpenClaw CLI across setup, gateway/node lifecycle, channel login, messaging, agent turns, models, plugins, and system health. Use when asked to choose, run, debug, or explain `openclaw` commands, global flags (`--dev`, `--profile`), or command families such as `gateway`, `agent`, `channels`, `message`, `doctor`, `status`, and `update`.
---

# OpenClaw CLI

Run OpenClaw commands safely and efficiently. Choose the right command family, execute with the correct profile context, and verify postconditions.

## Execution Workflow

1. Clarify the target state.
Ask what should change and what must remain untouched.

2. Select runtime scope first.
Use default profile unless isolation is requested. Use:
- `openclaw --dev ...` for isolated dev state under `~/.openclaw-dev`.
- `openclaw --profile <name> ...` for named isolated state under `~/.openclaw-<name>`.

3. Choose the command family.
Use `references/command-map.md` to route the request quickly.

4. Expand command details before running risky operations.
Run `openclaw <command> --help` for starred families and confirm flags.

5. Prefer machine-readable output when automation is needed.
Use `--json` where available, then parse/verify.

6. Verify outcomes explicitly.
Check with `openclaw status`, `openclaw health`, `openclaw nodes status --json`, or command-specific follow-up.

## Safety Rules

- Require explicit user confirmation before `reset`, `uninstall`, destructive `--force` flows, or credential-clearing operations.
- Prefer non-destructive diagnostics first: `status`, `health`, `doctor`, `logs`.
- Keep profile usage consistent across a workflow. Do not mix default and `--dev`/`--profile` commands accidentally.
- For gateway issues, diagnose before restart unless restart is explicitly requested.

## Triage Sequence

For generic "OpenClaw not working" issues:
1. Run `openclaw status`.
2. Run `openclaw health`.
3. Run `openclaw doctor`.
4. Check `openclaw gateway ...`, `openclaw node ...`, or `openclaw nodes ...` based on where failure appears.
5. Escalate to targeted commands in `references/command-map.md`.

## Resources

- `references/command-map.md`: Command families, routing guidance, and practical recipes.
