# CRON.md 분리 전략

> **목표**: 크론 메시지를 최대한 짧게 유지해 매 실행마다 낭비되는 토큰 최소화.

---

## 왜 CRON.md를 분리하는가?

OpenClaw 크론 작업은 일정 주기로 실행되며 매번 시스템 프롬프트 전체를 전송합니다.
CRON.md에 긴 지시문이 있으면 → **크론 실행 횟수 × 토큰 낭비**.

예시:
- 크론 30분 주기 × 24시간 = 하루 48번 실행
- CRON.md가 500토큰이면 → 48 × 500 = **24,000 토큰/일 낭비**
- 50토큰으로 줄이면 → 2,400 토큰/일 (90% 절약)

---

## 분리 전략

### ❌ BAD — 긴 CRON.md

```markdown
# CRON.md

## 매일 09:00 일정 정리
- 캘린더 확인하고 오늘 할 일 목록 정리
- 중요한 미팅이 있으면 30분 전에 텔레그램으로 알림 발송
- 투자자 미팅은 AGENTS.md의 IR 가이드라인 참고해서 준비
- 메모리 업데이트: memory/YYYY-MM-DD.md에 기록
- 완료 후 @tomas에게 "오늘 일정 정리 완료" 메시지 발송
```

### ✅ GOOD — 짧은 CRON.md

```markdown
# CRON.md

## cron: 0 9 * * *
일정정리: 캘린더→할일목록→텔레그램. 규칙=AGENTS.md
```

---

## 크론 메시지 Short 포맷 예시

```markdown
# CRON.md
# 목표: 항목당 1줄, 50토큰 이하

## cron: */30 * * * *
헬스체크: gateway status → 이상시 재시작

## cron: 0 9 * * 1-5
일정알림: 캘린더 확인 → 오늘미팅 텔레그램 요약

## cron: 0 18 * * *
일마감: memory/오늘.md 업데이트 → MEMORY.md 큐레이션

## cron: 0 0 * * 1
주간리포트: 지난주 stats → 텔레그램 발송

## cron: 0 */6 * * *
캐시유지: openclaw gateway status (heartbeat용)
```

---

## 규칙 요약

| 항목 | 권장 |
|------|------|
| 크론 항목당 길이 | 1줄, 50토큰 이하 |
| 상세 운영 규칙 | SOUL.md / AGENTS.md에 위임 |
| 참조 방법 | "규칙=AGENTS.md" 한 줄로 |
| 포맷 | `작업명: 동작1 → 동작2 → 결과` |

---

## 캐시와 크론의 관계

```
[SOUL.md + AGENTS.md + TOOLS.md]  ← 캐시됨 (heartbeat 59m으로 유지)
        ↓
    [CRON.md]  ← 짧을수록 캐시 히트율 ↑
        ↓
   크론 실행 메시지  ← 매번 새로 전송되므로 짧게!
```

CRON.md가 짧으면:
1. 시스템 프롬프트 길이 감소 → 캐시 히트율 ↑
2. 변경 빈도 감소 → 캐시 무효화 빈도 ↓
3. 크론 실행당 토큰 비용 최소화
