---
name: bitagent-skill
description: Launch, buy, and sell tokens on BitAgent bonding curves via CLI. Use when the user wants to create a new agent token, or trade existing agent tokens on BitAgent (BSC Testnet/Mainnet).
---

# BitAgent Skill

This skill uses the BitAgent SDK to interact with bonding curves on BSC. It runs as a **CLI only**: the agent must **execute** `scripts/index.ts` and **return the command’s stdout** to the user.

## Config (required)

Set in OpenClaw config under `skills.entries.bitagent-skill.env` (or similar) if it is not configured.

- `PRIVATE_KEY` — Wallet private key (0x...)

Ensure dependencies are installed at repo root (`npm install`).

## How to run (CLI)

Run from the **repo root** with env set. The CLI prints output to stdout. You must **capture that stdout and return it to the user**.

| Tool         | Command                                                                                                      | Result                                                                                               |
| ------------ | ------------------------------------------------------------------------------------------------------------ | ---------------------------------------------------------------------------------------------------- |
| **launch**   | `npx tsx scripts/index.ts launch --network <bsc\|bscTestnet> --name "<name>" --symbol "<symbol>" --reserve-symbol "<UB\|WBNB\|USD1>"` | Deploys a new agent token on a bonding curve. Returns the Contract Address and URL on success.       |
| **buy**      | `npx tsx scripts/index.ts buy --network <bsc\|bscTestnet> --token "<tokenAddress>" --amount "<amount>"`                                  | Buys a specific amount of tokens. Returns Transaction Hash.                                          |
| **sell**     | `npx tsx scripts/index.ts sell --network <bsc\|bscTestnet> --token "<tokenAddress>" --amount "<amount>"`                                 | Sells a specific amount of tokens. Returns Transaction Hash.                                         |

## Flow

1.  **Launch Agent:** When a user wants to create a token or agent, run the `launch` command. Ensure you ask for Name, Symbol, and which Reserve Token to use (UB, WBNB, USD1) if not provided.
2.  **Trade (Buy/Sell):** When a user wants to trade, use `buy` or `sell`. Requires the Token Address and Amount.

## File structure

- **Repo root** — `SKILL.md`, `package.json`.
- **scripts/index.ts** — CLI implementation.
