# OpenClaw Skills for BitAgent

**BitAgent** skill pack for [OpenClaw](https://github.com/openclaw/openclaw).

This package allows OpenClaw agents to interact with BitAgent bonding curves on BSC Mainnet and Testnet. Agents can launch new tokens, and buy or sell existing tokens directly through this skill.

The skill runs via the CLI plugin at **scripts/index.ts**, which provides the following capabilities: `launch`, `buy`, `sell`.

## Installation from Source

1. Clone the openclaw-bitagent repository with:

   ```bash
   git clone https://github.com/unibaseio/openclaw-bitagent bitagent-skill
   ```

   Make sure the repository cloned is renamed to `bitagent-skill` as this is the skill name.

2. **Add the skill directory** to OpenClaw config (`~/.openclaw/openclaw.json`):

   ```json
   {
     "skills": {
       "load": {
         "extraDirs": ["/path/to/bitagent-skill"]
       }
     }
   }
   ```

   Use the path to the root of this repository.

3. **Install dependencies**:

   ```bash
   cd /path/to/bitagent-skill
   npm install
   ```

## Configure Credentials

**Configure credentials** under `skills.entries.bitagent-skill.env`:

```json
{
  "skills": {
    "entries": {
      "bitagent-skill": {
        "enabled": true,
        "env": {
          "PRIVATE_KEY": "0x..."
        }
      }
    }
  }
}
```

| Variable      | Description                                      |
| ------------- | ------------------------------------------------ |
| `PRIVATE_KEY` | Wallet private key (0x...) for the agent wallet. |

**Note**: Chain selection (BSC Mainnet vs Testnet) is handled via the `--network` CLI flag (see SKILL.md) and does not require an environment variable.

## How it works

- The pack exposes one skill: **`bitagent-skill`**.
- The **SKILL.md** instructs the agent on how to use the CLI tools.
- The plugin **scripts/index.ts** is the CLI implementation.

**Capabilities**:
| Capability | Command Pattern | Description |
| ---------- | --------------- | ----------- |
| `launch` | `npx tsx scripts/index.ts launch ...` | Deploys a new agent token on a bonding curve. |
| `buy` | `npx tsx scripts/index.ts buy ...` | Buys a specific amount of tokens. |
| `sell` | `npx tsx scripts/index.ts sell ...` | Sells a specific amount of tokens. |

## Repository Structure

```
bitagent-skill/
├── SKILL.md           # Skill instructions for the agent
├── package.json       # Dependencies for the CLI
├── scripts/
│   └── index.ts       # CLI implementation
├── README.md
```
