# OpenClaw 行为计划 - 示例

## 示例 1：信息检索与汇总

**用户需求**：汇总过去一周关于 OpenClaw 的前 3 篇文章。

```markdown
# 行为计划：汇总 OpenClaw 近期文章

## 目标
获取过去一周内关于 OpenClaw 的前 3 篇文章，并生成简要汇总。

## 前置条件
- [ ] search_web 可用
- [ ] fetch_url 或类似能力可用（用于获取正文）

## 执行步骤

### 步骤 1: 搜索文章
- **目的**: 找到过去一周与 OpenClaw 相关的文章链接
- **工具/技能**: search_web
- **输入**: 查询词 "OpenClaw articles past week" 或等价中文
- **预期输出**: 若干 URL 列表，取前 3 个

### 步骤 2: 获取文章内容
- **目的**: 获取每篇文章的正文
- **工具/技能**: fetch_url（或 read_file 若为本地）
- **输入**: 依赖步骤 1 的 URL 列表
- **预期输出**: 3 篇文章的文本内容

### 步骤 3: 生成汇总
- **目的**: 对 3 篇文章进行摘要
- **工具/技能**: LLM 文本生成（或 summarize 类 skill）
- **输入**: 依赖步骤 2 的文本内容
- **预期输出**: 结构化汇总（标题、要点、来源）

### 步骤 4: 输出最终回复
- **目的**: 将汇总呈现给用户
- **工具/技能**: 最终文本响应（无 tool_call）
- **输入**: 步骤 3 的汇总
- **预期输出**: 用户可见的 Markdown 回复

## 异常与回退
- 若 search_web 无结果 → 放宽时间范围或关键词重试
- 若某 URL 获取失败 → 跳过该篇，用第 4 篇替补

## 完成标准
- [ ] 至少 3 篇文章被成功获取
- [ ] 汇总包含标题、要点、来源链接
- [ ] 用户收到可读的最终回复
```

---

## 示例 2：本地文件处理

**用户需求**：读取项目中的 config.yaml，检查是否有敏感信息，并生成报告。

```markdown
# 行为计划：配置文件敏感信息检查

## 目标
读取 config.yaml，识别潜在敏感信息（密钥、密码、token 等），输出检查报告。

## 前置条件
- [ ] read_file 可用
- [ ] 用户已提供或可推断 config.yaml 路径

## 执行步骤

### 步骤 1: 读取配置文件
- **目的**: 获取 config.yaml 内容
- **工具/技能**: read_file
- **输入**: 文件路径（如 ./config.yaml 或用户指定路径）
- **预期输出**: 文件全文

### 步骤 2: 分析敏感字段
- **目的**: 识别密钥、密码、token、API key 等模式
- **工具/技能**: LLM 文本分析（无 tool_call，基于步骤 1 内容）
- **输入**: 依赖步骤 1 的文件内容
- **预期输出**: 敏感字段列表及位置

### 步骤 3: 生成报告
- **目的**: 输出结构化检查报告
- **工具/技能**: 最终文本响应
- **输入**: 步骤 2 的分析结果
- **预期输出**: Markdown 报告（含建议）

## 异常与回退
- 若文件不存在 → 返回明确错误，建议用户确认路径
- 若文件过大 → 仅分析前 N 行或摘要

## 完成标准
- [ ] 文件被成功读取
- [ ] 敏感信息模式被识别
- [ ] 用户收到可操作的报告
```

---

## 示例 3：多技能协作

**用户需求**：查看明天日历，找出空闲时段，并给团队发 Slack 消息提议开会时间。

```markdown
# 行为计划：基于日历的会议时间提议

## 目标
根据用户明日日历空闲时段，向团队 Slack 频道发送会议时间提议。

## 前置条件
- [ ] calendar skill（get_events, find_free_slots）已安装
- [ ] slack skill（post_message）已安装
- [ ] 用户已授权 calendar 与 slack

## 执行步骤

### 步骤 1: 获取明日事件
- **目的**: 了解明日已有安排
- **工具/技能**: calendar.get_events
- **输入**: date = 明日日期
- **预期输出**: 事件列表

### 步骤 2: 计算空闲时段
- **目的**: 找出可开会的时间段
- **工具/技能**: calendar.find_free_slots
- **输入**: 依赖步骤 1 的事件，duration = 60（分钟）
- **预期输出**: 空闲时段列表（如 10:00-11:00, 14:00-15:00）

### 步骤 3: 发送 Slack 消息
- **目的**: 向团队提议会议时间
- **工具/技能**: slack.post_message
- **输入**: channel、消息内容（含步骤 2 的空闲时段）
- **预期输出**: 消息发送成功确认

### 步骤 4: 确认完成
- **目的**: 告知用户操作结果
- **工具/技能**: 最终文本响应
- **输入**: 步骤 3 的结果
- **预期输出**: 用户可见的总结

## 异常与回退
- 若无空闲时段 → 扩大日期范围或缩短 duration
- 若 Slack 发送失败 → 返回错误信息，建议用户检查权限

## 完成标准
- [ ] 至少找到一个空闲时段
- [ ] Slack 消息已发送
- [ ] 用户收到操作总结
```
