---
name: Twitter Command Center (Search + Post)
description: "Search X (Twitter) in real time, extract relevant posts, and publish tweets/replies instantly—perfect for social listening, engagement, and rapid content ops."
homepage: https://openclaw.ai
metadata: {"openclaw":{"emoji":"🐦","requires":{"bins":["curl","python3"],"env":["AISA_API_KEY"]},"primaryEnv":"AISA_API_KEY"}}
---

# OpenClaw Twitter 🐦

**Twitter/X data access and automation for autonomous agents. Powered by AIsa.**

One API key. Full Twitter intelligence.

## 🔥 What Can You Do?

### Monitor Influencers
```
"Get Elon Musk's latest tweets and notify me of any AI-related posts"
```

### Track Trends
```
"What's trending on Twitter worldwide right now?"
```

### Social Listening
```
"Search for tweets mentioning our product and analyze sentiment"
```

### Automated Engagement
```
"Like and retweet posts from @OpenAI that mention GPT-5"
```

### Competitor Intel
```
"Monitor @anthropic and @GoogleAI - alert me on new announcements"
```

## Quick Start

```bash
export AISA_API_KEY="your-key"
```

## Core Capabilities

### Read Operations (No Login Required)

```bash
# Get user info
curl "https://api.aisa.one/apis/v1/twitter/user/info?userName=elonmusk" \
  -H "Authorization: Bearer $AISA_API_KEY"

# Get user's latest tweets
curl "https://api.aisa.one/apis/v1/twitter/user/user_last_tweet?userName=elonmusk" \
  -H "Authorization: Bearer $AISA_API_KEY"

# Advanced tweet search (queryType is required: Latest or Top)
curl "https://api.aisa.one/apis/v1/twitter/tweet/advanced_search?query=AI+agents&queryType=Latest" \
  -H "Authorization: Bearer $AISA_API_KEY"

# Search top tweets
curl "https://api.aisa.one/apis/v1/twitter/tweet/advanced_search?query=AI+agents&queryType=Top" \
  -H "Authorization: Bearer $AISA_API_KEY"

# Get trending topics (worldwide)
curl "https://api.aisa.one/apis/v1/twitter/trends?woeid=1" \
  -H "Authorization: Bearer $AISA_API_KEY"

# Search users by keyword
curl "https://api.aisa.one/apis/v1/twitter/user/search_user?keyword=AI+researcher" \
  -H "Authorization: Bearer $AISA_API_KEY"

# Get tweets by ID
curl "https://api.aisa.one/apis/v1/twitter/tweet/tweetById?tweet_ids=123456789" \
  -H "Authorization: Bearer $AISA_API_KEY"

# Get user followers
curl "https://api.aisa.one/apis/v1/twitter/user/user_followers?userName=elonmusk" \
  -H "Authorization: Bearer $AISA_API_KEY"

# Get user followings
curl "https://api.aisa.one/apis/v1/twitter/user/user_followings?userName=elonmusk" \
  -H "Authorization: Bearer $AISA_API_KEY"
```

### Write Operations (Requires Login)

> ⚠️ **Warning**: Posting requires account login. Use responsibly to avoid rate limits or account suspension.

```bash
# Step 1: Login first (async, check status after)
curl -X POST "https://api.aisa.one/apis/v1/twitter/user_login_v3" \
  -H "Authorization: Bearer $AISA_API_KEY" \
  -H "Content-Type: application/json" \
  -d '{"user_name":"myaccount","email":"me@example.com","password":"xxx","proxy":"http://user:pass@ip:port"}'

# Step 2: Check login status
curl "https://api.aisa.one/apis/v1/twitter/get_my_x_account_detail_v3?user_name=myaccount" \
  -H "Authorization: Bearer $AISA_API_KEY"

# Send tweet
curl -X POST "https://api.aisa.one/apis/v1/twitter/send_tweet_v3" \
  -H "Authorization: Bearer $AISA_API_KEY" \
  -H "Content-Type: application/json" \
  -d '{"user_name":"myaccount","text":"Hello from OpenClaw!"}'

# Like a tweet
curl -X POST "https://api.aisa.one/apis/v1/twitter/like_tweet_v3" \
  -H "Authorization: Bearer $AISA_API_KEY" \
  -H "Content-Type: application/json" \
  -d '{"user_name":"myaccount","tweet_id":"1234567890"}'

# Retweet
curl -X POST "https://api.aisa.one/apis/v1/twitter/retweet_v3" \
  -H "Authorization: Bearer $AISA_API_KEY" \
  -H "Content-Type: application/json" \
  -d '{"user_name":"myaccount","tweet_id":"1234567890"}'

# Update profile
curl -X POST "https://api.aisa.one/apis/v1/twitter/update_profile_v3" \
  -H "Authorization: Bearer $AISA_API_KEY" \
  -H "Content-Type: application/json" \
  -d '{"user_name":"myaccount","name":"New Name","bio":"New bio"}'
```

## Python Client

```bash
# User operations
python3 {baseDir}/scripts/twitter_client.py user-info --username elonmusk
python3 {baseDir}/scripts/twitter_client.py tweets --username elonmusk
python3 {baseDir}/scripts/twitter_client.py followers --username elonmusk
python3 {baseDir}/scripts/twitter_client.py followings --username elonmusk

# Search & Discovery
python3 {baseDir}/scripts/twitter_client.py search --query "AI agents"
python3 {baseDir}/scripts/twitter_client.py user-search --keyword "AI researcher"
python3 {baseDir}/scripts/twitter_client.py trends --woeid 1

# Post operations (requires login)
python3 {baseDir}/scripts/twitter_client.py login --username myaccount --email me@example.com --password xxx --proxy "http://user:pass@ip:port"
python3 {baseDir}/scripts/twitter_client.py post --username myaccount --text "Hello!"
python3 {baseDir}/scripts/twitter_client.py like --username myaccount --tweet-id 1234567890
python3 {baseDir}/scripts/twitter_client.py retweet --username myaccount --tweet-id 1234567890
```

## API Endpoints Reference

| Endpoint | Method | Description |
|----------|--------|-------------|
| `/twitter/user/info` | GET | Get user profile |
| `/twitter/user/user_last_tweet` | GET | Get user's recent tweets |
| `/twitter/user/user_followers` | GET | Get user followers |
| `/twitter/user/user_followings` | GET | Get user followings |
| `/twitter/user/search_user` | GET | Search users by keyword |
| `/twitter/tweet/advanced_search` | GET | Advanced tweet search |
| `/twitter/tweet/tweetById` | GET | Get tweets by IDs |
| `/twitter/trends` | GET | Get trending topics |
| `/twitter/user_login_v3` | POST | Login to account |
| `/twitter/send_tweet_v3` | POST | Send a tweet |
| `/twitter/like_tweet_v3` | POST | Like a tweet |
| `/twitter/retweet_v3` | POST | Retweet |

## Pricing

| API | Cost |
|-----|------|
| Twitter read query | ~$0.0004 |
| Twitter post/like/retweet | ~$0.001 |

Every response includes `usage.cost` and `usage.credits_remaining`.

## Get Started

1. Sign up at [aisa.one](https://aisa.one)
2. Get your API key
3. Add credits (pay-as-you-go)
4. Set environment variable: `export AISA_API_KEY="your-key"`

## Full API Reference

See [API Reference](https://aisa.mintlify.app/api-reference/introduction) for complete endpoint documentation.
