# Safeguards (Anti-loop + Budget + Human Control)

Use this when an OpenClaw agent is **looping**, **burning tokens**, or repeatedly failing the same tool/action.

---

## 0) Quick triage (find the repeating unit)
- Same tool call failing? (exec/browser/web_fetch/cron.update)
- Same prompt being retried?
- Provider cooldown / rate limit storms?
- Tool outputs too large (session lists, status cards, long logs)?

Decide whether it’s safe to auto-fix or must ask the user.

---

## 1) Hard stop rules (prompt-level)
- Same error ≥ 2–3 times → **stop** and ask for human input.
- No blind retry loops for cooldown/rate limits; throttle or defer to next schedule.
- Prefer deterministic scripts over repeated re-planning.

---

## 2) Budget guardrails (behavioral)
General patterns:
- Reduce scope (top K, cap lines/chars).
- Reduce frequency (tiered cadence).
- Switch to alert-only delivery.
- Degrade gracefully: “minimal mode + one alert” instead of repeated retries.

If the platform supports explicit caps (per-session cost/tokens), enable them.

---

## 3) Heartbeat & cron runaway prevention

### Heartbeat
- Treat heartbeat as control-plane.
- If heartbeat is expensive, adopt profiles:
  - **A:** ack-only
  - **B:** light monitor (throttled)
  - **C:** full monitor

If adopting A/B reduces coverage, present trade-offs and let the user choose.

### Cron
- Script-first (one exec) + idempotent.
- Deliver only on change/error.
- Split collector/reporter if you need periodic reporting.

---

## 4) Loop detection (conceptual)
True enforcement may require middleware, but you can approximate via prompts:
- step limits
- similarity detection on recent tool calls
- repeated identical stderr messages

Action on detection: stop + emit “need help” + write diagnostics.

---

## 5) Human-in-the-loop approvals
Use approvals for dangerous/high-cost actions:
- risky exec patterns
- restricted browser domains
- persistent configuration changes (`config.apply`, `config.patch`, `update.run`)
- cron creation/update/removal

Before applying persistent changes, provide:
- exact change/diff
- expected impact
- rollback plan

---

## 6) File hygiene to prevent silent token sinks
- Rotate/trim logs that grow without bound.
- Avoid reading large files frequently; summarize to a compact artifact.
