# Optimization Playbook (General, Model-Agnostic)

A reusable checklist for reducing cost, improving determinism, and keeping OpenClaw automation maintainable.

This playbook is **model-agnostic**: it avoids naming specific providers/models. Use the cheapest tier that reliably works.

---

## 0) First question: Where is the cost coming from?

Before changing behavior, identify the dominant cost driver:
- Frequent triggers (heartbeat / high-frequency cron)
- Large tool outputs (session lists, status cards, long logs)
- Long prompts repeated each run
- Non-idempotent tasks causing rework

If available, use usage/cost instrumentation (ledger, status deltas) to validate wins.

---

## 1) Choose a profile (user must choose if coverage changes)

Execution stance: advisory-first. Do not apply persistent config/cron changes until the user explicitly approves.

When optimization reduces coverage/frequency or removes checks, present trade-offs and let the user pick.

### Profile A — Ultra Low Cost
- Heartbeat: ack-only (no tools)
- Cron: collector jobs deliver=false by default
- Reporting: only on change/error

### Profile B — Balanced
- Heartbeat: light monitor with throttles
- Cron: alert-only + periodic summary (e.g., daily)

### Profile C — Maximum Coverage
- Heartbeat: full checklist
- Cron: full scan + frequent reporting

---

## 2) Heartbeat: keep it control-plane

Rules:
- Heartbeat should decide “do we need action?” not do the heavy work.
- Move heavy work to isolated cron or scripts.
- Never call large-output tools on every poll unless user explicitly accepts the cost.
- If heartbeat turns are still expensive due to large **input/cache context**, consider disabling heartbeat delivery and relying on cron reporting instead (e.g., set `agents.defaults.heartbeat.target = "none"`).

---

## 3) Cron: script-first + alert-only delivery

Patterns:
- Cron payload should be one command (script execution).
- Script reads small config/state files, writes artifacts to `memory/`.
- Return `NO_REPLY` when nothing changed.

Split jobs:
- Collector (frequent, deliver=false)
- Reporter (less frequent, deliver=true)

---

## 4) Throttles, caps, and idempotency

Throttles:
- Time-based: heavy step only every N runs
- Change-based: hash inputs; skip if unchanged

Caps:
- limit returned text size (lines/chars)
- limit scan scope (top K items)

Idempotency:
- maintain a cursor file
- append-only JSONL logs for audits

---

## 5) Safe escalation and fallback

- Default to the cheapest tier that works.
- Escalate tier only after repeated failures or when correctness matters.
- If a tool fails repeatedly: stop, log diagnostics, and ask for human input.

---

## 6) Deliver policy

Avoid spam:
- deliver=false by default
- deliver=true only for: anomalies, new actionable signals, or explicit reports

---

## 7) Documentation hygiene

- Put long instructions in references/scripts, not in cron prompts.
- Keep rules modular.
- Keep memory files small; rotate/trim logs that grow without bound.
