# Memory Patterns (Daily + Long-Term + Size Control)

## Files
- **Daily log:** `memory/YYYY-MM-DD.md` (raw events, decisions, links)
- **Long-term:** `MEMORY.md` (curated, stable preferences/guardrails/config facts)

## Distillation rules
- Keep only what survives a restart: preferences, guardrails, key configs, and stable decisions.
- Move transient details to daily logs.
- Summarize big threads into 1–3 bullets with pointers to artifacts.

## Size control (prevents hidden token burn)
- Logs that grow forever become “silent token sinks” when read frequently.

Patterns:
- Keep state files small (`*-state.json`).
- Use JSONL for append-only ledgers; summarize with a separate reporter.
- Rotate/trim large logs (keep last N entries) unless the user explicitly wants full retention.

## Cadence
- Distill daily logs into `MEMORY.md` periodically.
- Keep `MEMORY.md` short and actionable.
