# Continuous Learning (Hooks → Skills) + Cost Feedback

## Two-layer approach
- **Hooks (deterministic):** capture small, repeatable "instincts" around tool usage and workflows.
- **Skills (probabilistic):** distill clusters of instincts into reusable skill docs/scripts.

## OpenClaw adaptation
- Session-start: load minimal context.
- Session-end: write a short summary and extract repeatable patterns.
- Pre-compact: save critical state before context loss.

## Cost feedback loop (recommended)
To prevent “optimizations” that accidentally increase spend:
- Measure before/after using whatever telemetry is available (status deltas, usage ledger, cron run stats).
- Prefer changes that reduce:
  - trigger frequency
  - tool payload size
  - repeated long prompts

## Confidence scoring
- Score patterns 0.3–0.9 based on reliability.
- Promote only high-confidence patterns into skills.
