# Context Management (Progressive Disclosure + Cost Hygiene)

## Window discipline
- Don’t enter the last ~20% of context when doing multi-file edits or refactors.
- If near the limit, prefer `/compact` **before** continuing.

## Progressive disclosure (3 levels)
1. **Metadata always visible:** filenames, brief summaries, TODOs.
2. **Body on trigger:** load only the file/section needed.
3. **Heavy resources on demand:** move schemas/docs to `references/` or scripts.

## Cost hygiene patterns
- Avoid repeatedly pasting large tool outputs into the conversation.
- Prefer scripts that output a small, bounded summary.
- Use fixed-size summaries: top K items, max X lines, max Y chars.

## OpenClaw practices
- Store large/static content under `references/`.
- Store state in small JSON files; rotate/trim logs that grow without bound.
- If session store accumulates stale cron sessions/orphan transcripts, run `context-clean-up` session-store hygiene (dry-run first, backup-first apply).
- Batch related decisions into a single user question (reduce back-and-forth).
