# Agent Orchestration (Parallel-First + Cost-Aware)

## Core rules
- **Parallelize independent tasks.** If task B does not depend on task A, spawn both.
- Keep main session clean: delegate long/noisy work to isolated sub-agents.

## Cost-aware delegation
- Pass **minimal context** (goal, constraints, file paths).
- Prefer sub-agents for:
  - long-running research
  - multi-step automation
  - work that benefits from isolation (cron-like behavior)

## Output discipline
- Sub-agents should:
  - write artifacts to files
  - return a short summary + next actions
  - avoid dumping long tool outputs into chat

## Delivery discipline
- For automated runs, prefer **alert-only** delivery:
  - `NO_REPLY` if nothing changed
  - message only for new actionable signals or errors

## Split-role delegation (when needed)
- Engineer: implement
- Reviewer: correctness & style
- Security: risk assessment

## Logging / recovery
- Log sub-agent runs to `memory/delegation_log.json` for crash recovery.
- Rotate/trim logs if they grow without bound.
