---
name: openapi2cli
description: Generate CLI tools from OpenAPI specs. Built for AI agents who hate writing curl commands.
homepage: https://github.com/Olafs-World/openapi2cli
metadata:
  {
    "openclaw":
      {
        "emoji": "🔧",
        "requires": { "bins": ["uvx"] },
        "install":
          [
            {
              "id": "uv",
              "kind": "pip",
              "package": "uv",
              "bins": ["uvx"],
              "label": "Install uv (for uvx)",
            },
          ],
      },
  }
---

# OpenAPI to CLI

Generate command-line tools from OpenAPI/Swagger specs. Perfect for AI agents that need to interact with APIs without writing curl commands.

## Quick Start

```bash
# generate a CLI from any OpenAPI spec
uvx openapi2cli generate https://api.example.com/openapi.json --output my-api

# use the generated CLI
python my-api.py users list
python my-api.py users get --id 123
python my-api.py posts create --title "Hello" --body "World"
```

## Features

- **Auto-generates CLI** from OpenAPI 3.x specs
- **Supports auth**: API keys, Bearer tokens, Basic auth
- **Rich help**: `--help` on any command shows params
- **JSON output**: Structured responses for parsing
- **Dry-run mode**: See the request without sending

## Usage

```bash
# from URL
uvx openapi2cli generate https://api.example.com/openapi.json -o my-cli

# from local file  
uvx openapi2cli generate ./spec.yaml -o my-cli

# with base URL override
uvx openapi2cli generate ./spec.json -o my-cli --base-url https://api.prod.com
```

## Generated CLI

```bash
# set auth via env
export MY_CLI_API_KEY="sk-..."

# or via flag
python my-cli.py --api-key "sk-..." users list

# see available commands
python my-cli.py --help

# see command options
python my-cli.py users create --help
```

## Example: GitHub API

```bash
uvx openapi2cli generate https://raw.githubusercontent.com/github/rest-api-description/main/descriptions/api.github.com/api.github.com.json -o github-cli

python github-cli.py repos list --owner octocat
```

## Why?

AI agents work better with CLIs than raw HTTP:
- Discoverable commands via `--help`
- Tab completion friendly
- No need to construct JSON payloads
- Easy to chain with pipes

## Links

- [PyPI](https://pypi.org/project/openapi2cli/)
- [GitHub](https://github.com/Olafs-World/openapi2cli)
