---
name: opc
description: OPC (One-Person Company) Framework - Complete AI agent system for solo entrepreneurs with 14 integrated skills. From ideation to deployment - creative planning, market research, proposal writing, PRD generation, development, testing, deployment, operations, and more.
metadata:
  openclaw:
    emoji: 🏢
    os: [darwin, linux]
    requires: {}
    install: []
---

# OPC (One-Person Company) Framework 🏢

A comprehensive AI-powered framework for solo entrepreneurs to build and scale their one-person company.

## What's OPC?

OPC (One-Person Company) Framework is a complete skill stack that helps solo entrepreneurs go from idea to execution using AI agents.

## 14 Integrated Skills

| Category | Skill | Description |
|----------|-------|-------------|
| 📌 Planning | creative-planning | Business idea generation and validation |
| 📊 Research | market-research | Competitor and market analysis |
| 📝 Writing | proposal-writing | Investor pitches and proposals |
| 🔍 Review | proposal-review | Proposal quality assurance |
| 📋 Product | prd-generation | Product requirement documents |
| 📅 Project | project-manager | Project roadmap and tracking |
| 💻 Development | development | Code generation and implementation |
| 🧪 Testing | testing | QA and automation testing |
| 🚀 Deploy | deployment | CI/CD and deployment |
| ⚙️ Ops | operations | Monitoring and maintenance |
| 📡 Social | social-listening | Brand monitoring |
| 🌐 Brand | domain-brand | Naming and domain strategy |
| 🔧 Tools | tool-search | AI tool discovery |
| 🔗 Integrations | evomap | EvoMap marketplace integration |

## Requirements

- OpenClaw agent runtime
- Access to various LLM providers (optional for enhanced capabilities)

## Quick Start

1. Install the skill in your OpenClaw workspace
2. Configure your preferred LLM provider
3. Start with "creative-planning" skill to ideate
4. Progress through the workflow: research → write → develop → deploy → operate

## Usage Example

```
User: I want to build a SaaS product
OPC: Great! Let's start with creative-planning...
```

## Skills Structure

Each skill is independent but can work together as a complete workflow.

## Credits

- Built on OpenClaw infrastructure
- Designed for solopreneurs and indie hackers

---

**Tags**: #ai #agent #solopreneur #startup #one-person-company #mvp #lean-startup
