# OnlyFansAPI Skill

An [Agent Skill](https://agentskills.io) that lets AI coding agents query OnlyFans data and analytics through the [OnlyFansAPI.com](https://onlyfansapi.com) platform.

## What it does

This skill gives agents the ability to:

- **Revenue summaries** — Get total earnings across all models for any time period
- **Model performance** — Identify your top-performing model by net revenue
- **Free Trial Link analytics** — Find which trial links have the highest subscriber-to-spender conversion rate
- **Tracking Link analytics** — Find which tracking links convert best and generate the most revenue
- **Earnings breakdowns** — Filter by subscriptions, tips, posts, messages, or streams
- **Much much more** - With OnlyFansAPI.com supporting over 200+ endpoints, you're able to access absolutely anything related to OnlyFans.

All queries support multi-account (agency) workflows, automatically aggregating data across all connected models.

## Setup

1. Sign up at [OnlyFansAPI.com](https://onlyfansapi.com) and connect your OnlyFans account(s)
2. Create an API key at <https://app.onlyfansapi.com/api-keys>
3. Set the environment variable:

```bash
export ONLYFANSAPI_API_KEY="your_api_key_here"
```

## Example questions

- "What is the revenue of all my models for the past 7 days?"
- "Which model is performing the best this month?"
- "Which Free Trial Link has the highest conversion rate from subscribers to spenders?"
- "Which Tracking Link made the most money?"
- "Show me a breakdown of tip revenue vs message revenue for the past 30 days"

## Requirements

- `curl` and `jq` available on PATH
- Network access to `app.onlyfansapi.com`
- A valid OnlyFansAPI API key

## Documentation

- [OnlyFansAPI Docs](https://docs.onlyfansapi.com) — Full API reference
- [OnlyFansAPI Console](https://app.onlyfansapi.com) — OnlyFansAPI Console Required for using the skill
