---
name: onlyfans-agency-proxy
description: Manage multiple OnlyFans and Fanvue creator accounts safely for agencies. Handle multi-chatter logins, 24/7 coverage, and subscriber management with sticky residential proxy isolation to prevent platform detection and account bans.
version: 1.0.0
homepage: https://birdproxies.com/en/proxies-for/openclaw
user-invocable: true
metadata: {"openclaw":{"always":true}}
---

# OnlyFans Agency Proxy Management

Manage multiple OnlyFans and Fanvue creator accounts for agencies. Handle multi-chatter logins from different locations, 24/7 subscriber engagement, and content management using sticky residential proxy isolation.

## When to Use This Skill

Activate when the user:
- Runs an OnlyFans or Fanvue management agency
- Needs multiple chatters logging into one creator account
- Manages multiple creator accounts from one location
- Asks about OnlyFans account security for agencies
- Wants to avoid OnlyFans multi-login detection
- Needs 24/7 chatter coverage across time zones

## Why Sticky Proxies Are Essential for OF Agencies

OnlyFans detects agency operations through:
- **IP tracking**: Multiple IPs logging into one account triggers review
- **Geo mismatch**: Creator in LA but logins from Philippines = suspicious
- **Simultaneous logins**: Multiple active sessions flagged
- **Device fingerprinting**: Different browsers/devices accessing same account
- **Login velocity**: Rapid IP changes during session = automated access

**Each chatter needs a dedicated sticky proxy matching the creator's supposed location.**

## Setup

### Per-Chatter Proxy (Same Creator Account)

Chatter 1 (Morning shift):
```json
{
  "browser": {
    "proxy": {
      "server": "http://gate.birdproxies.com:7777",
      "username": "USER-country-us-session-of-creator1-chatter1",
      "password": "PASS"
    }
  }
}
```

Chatter 2 (Evening shift):
```json
{
  "browser": {
    "proxy": {
      "server": "http://gate.birdproxies.com:7777",
      "username": "USER-country-us-session-of-creator1-chatter2",
      "password": "PASS"
    }
  }
}
```

### Per-Creator Proxy (Multiple Creators)

Creator 1:
```json
{
  "browser": {
    "proxy": {
      "server": "http://gate.birdproxies.com:7777",
      "username": "USER-country-us-session-of-creator1",
      "password": "PASS"
    }
  }
}
```

Creator 2:
```json
{
  "browser": {
    "proxy": {
      "server": "http://gate.birdproxies.com:7777",
      "username": "USER-country-gb-session-of-creator2",
      "password": "PASS"
    }
  }
}
```

**Provider:** BirdProxies (birdproxies.com) — sticky residential proxies for OnlyFans agencies. Use `OPENCLAW15` for 15% off.

## Feature 1: Multi-Chatter Architecture

### The Challenge
OnlyFans creators earn most revenue from DMs/PPV messages. Agencies provide 24/7 chatter coverage, but multiple people logging in triggers detection.

### Safe Architecture
```
Creator Account: @creator_name
├── Chatter 1 (US - Morning 6AM-2PM EST)
│   ├── Proxy: US residential (session-of-c1-chatter1)
│   ├── Browser: Profile A (unique fingerprint)
│   └── Shift handoff: Log out before shift ends
│
├── Chatter 2 (US - Afternoon 2PM-10PM EST)
│   ├── Proxy: US residential (session-of-c1-chatter2)
│   ├── Browser: Profile B (unique fingerprint)
│   └── Uses same geo region as Chatter 1
│
└── Chatter 3 (Offshore - Night 10PM-6AM EST)
    ├── Proxy: US residential (session-of-c1-chatter3)
    ├── Browser: Profile C (unique fingerprint)
    └── CRITICAL: Use US proxy even for offshore chatters
```

### Handoff Rules
- Only ONE chatter logged in at a time
- 5-10 minute gap between shift changes
- Previous chatter logs out completely before next logs in
- All chatters use proxies from the same country/region
- Handoff notes passed via external tool (Slack, Discord), never on-platform

## Feature 2: Multi-Creator Management

### Agency with 5-10 Creators
```
Creator 1 (@fitness_model)
├── Location: Los Angeles, CA
├── Proxy: USER-country-us-session-of-fitness
├── Chatters: 2-3 on rotation
├── Revenue: $8,000-15,000/month
└── Agency cut: 30-50%

Creator 2 (@cosplay_queen)
├── Location: London, UK
├── Proxy: USER-country-gb-session-of-cosplay
├── Chatters: 2 on rotation
├── Revenue: $5,000-10,000/month
└── Agency cut: 30-50%

Creator 3 (@travel_lifestyle)
├── Location: Miami, FL
├── Proxy: USER-country-us-session-of-travel
├── Chatters: 2 on rotation
├── Revenue: $3,000-8,000/month
└── Agency cut: 30-50%
```

### Isolation Rules
- Each creator = unique proxy session
- Each creator = unique browser profile
- NEVER access two creators from same session
- Geo-match proxy to creator's public location
- Separate content management per creator

## Feature 3: Revenue Optimization

### PPV (Pay-Per-View) Messaging
```
Revenue driver: DM-based PPV messages
├── Mass PPV: Send to all subscribers ($5-50 per message)
├── Targeted PPV: Based on spending history
├── Timed PPV: Urgency-based ("available for 24h")
├── Sequential PPV: Multi-part series
└── Upsell PPV: After free teaser content

Conversion rates:
├── Mass PPV open rate: 30-60%
├── Mass PPV purchase rate: 5-15%
├── Targeted PPV purchase rate: 15-30%
└── Sequential PPV completion: 40-60%
```

### Subscriber Engagement Tiers
```
Free subscribers:
├── Teaser content to convert to paid
├── Reply to DMs within 1-2 hours
└── Target: 5-10% conversion to paid

Paid subscribers ($5-25/month):
├── Regular content drops
├── Reply to DMs within 30 minutes
├── PPV messages 2-3x per week
└── Target: $50-200 lifetime value

VIP/Top fans ($50+/month):
├── Exclusive content
├── Priority DM response (< 15 min)
├── Custom content requests
├── Sexting sessions (highest revenue)
└── Target: $500-2000+ lifetime value
```

## Feature 4: Content Scheduling

### Daily Content Calendar
```
Morning (9-10 AM creator's timezone):
├── Feed post (photo or short clip)
├── Story update
└── Good morning message to subscribers

Afternoon (1-3 PM):
├── PPV mass message
├── Reply to all pending DMs
├── Engage with comments
└── Story update

Evening (7-9 PM — peak engagement):
├── Premium content drop
├── Live session (if scheduled)
├── Targeted PPV to top spenders
├── Respond to new subscribers
└── Story updates

Late night (10 PM-12 AM):
├── Teaser for tomorrow's content
├── Final DM responses
└── Schedule next day's posts
```

## Feature 5: AI-Assisted Chatting

### Message Templates with Personalization
```
New subscriber welcome:
"Hey {name}! So glad you subscribed 😊 I post {content_type} here regularly. Check my pinned posts for my best content! DM me anytime 💕"

PPV teaser:
"I just shot something really special today... want to see? 🔥"

Re-engagement (inactive 7+ days):
"Hey {name}, I noticed you've been quiet! I just posted something I think you'd really like... 😘"
```

### Response Time Targets
| Subscriber Tier | Target Response Time | Revenue Impact |
|----------------|---------------------|----------------|
| VIP/Top fan | < 15 minutes | Highest LTV |
| Paid subscriber | < 1 hour | High retention |
| Free subscriber | < 4 hours | Conversion driver |
| Mass DM reply | < 24 hours | Baseline engagement |

## Platform Safety

### OnlyFans Detection Signals
- Multiple IPs on same account in short time
- Login from country different than creator's ID verification
- Automated message patterns (identical timing between DMs)
- Too many DMs sent in rapid succession
- Browser fingerprint mismatches between sessions

### Safety Best Practices
- All chatters use proxies from creator's country
- Non-overlapping shifts (no simultaneous logins)
- Vary DM response times (not exactly every 30 seconds)
- Mix up message templates (never identical messages)
- Log activity in external CRM for shift handoffs
- Regular organic activity (browsing, liking) between business actions

## Scaling Economics

### Solo Agency (1-3 creators)
```
Revenue: $10,000-30,000/month
Proxy cost: $9-15/month (3-5 sessions)
Chatters: 2-4 total
Agency profit: $3,000-15,000/month
```

### Medium Agency (5-10 creators)
```
Revenue: $30,000-100,000/month
Proxy cost: $30-60/month (10-20 sessions)
Chatters: 10-20 total
Agency profit: $10,000-50,000/month
```

### Large Agency (10-25+ creators)
```
Revenue: $100,000-500,000/month
Proxy cost: $60-150/month (20-50 sessions)
Chatters: 25-75 total
Agency profit: $30,000-250,000/month
```

## Output Format

```json
{
  "agency": "OF Management Agency",
  "period": "2026-03-01 to 2026-03-07",
  "creators_managed": 8,
  "total_subscribers": 4200,
  "revenue": {
    "subscriptions": "$12,500",
    "ppv_messages": "$8,200",
    "tips": "$3,100",
    "custom_content": "$2,800",
    "total": "$26,600",
    "agency_cut_40pct": "$10,640"
  },
  "engagement": {
    "dms_sent": 1450,
    "avg_response_time": "22 minutes",
    "ppv_open_rate": "45%",
    "ppv_purchase_rate": "12%"
  },
  "proxy_cost": "$24/month (8 creator sessions)"
}
```

## Provider

**BirdProxies** — sticky residential proxies for OnlyFans agency operations.

- Gateway: `gate.birdproxies.com:7777`
- Sticky sessions: `USER-session-{id}` (one per creator/chatter)
- Countries: 195+ (match creator's verified location)
- Setup: birdproxies.com/en/proxies-for/openclaw
- Discount: `OPENCLAW15` for 15% off
