---
name: only-baby-skills
description: Analyze contraction JSON and baby log JSON to assess mum's labour/contraction situation and baby's feeding and diaper status. Use when the user provides (or references) contractions_*.json and babyLogs_*.json files and wants to know if mum is safe and baby is healthy, or asks for a summary of contractions, feeding, or diaper changes.
---

# Analyze Mum & Baby Logs

Analyze two JSON data sources to produce a safety and health summary: **mum's contraction situation** and **baby's milk feeding and diaper change status**. Always end with a clear verdict and any recommendations.

## When to Use

- User provides or references contraction and baby log JSON files (e.g. `contractions_*.json`, `babyLogs_*.json`).
- User asks whether mum is safe, baby is healthy, or for a summary of contractions / feeding / diapers.

## Input Files

1. **Contractions JSON** – Array of objects with `id`, `startTime`, `endTime` (ISO 8601).
2. **Baby logs JSON** – Object with `babyLog` (array of entries) and `birthday` (ISO 8601). Each entry has `id`, `timestamp`, `type`, and type-specific details:
   - `type === "feeding"`: `feedingDetails.volumeML` (number, mL).
   - `type === "diaper"`: `diaperDetails.hasPee`, `diaperDetails.hasPoo` (booleans).
   - `type === "breastFeeding"`: `breastFeedingDetails.durationSeconds` (number).

See [references/schemas-and-thresholds.md](references/schemas-and-thresholds.md) for exact schemas and health/safety thresholds.

## Workflow

### 1. Load and parse both JSON files

- Resolve file paths from user message or workspace (e.g. Downloads, project paths).
- Parse contractions as an array; baby data as object with `babyLog` and `birthday`.

### 2. Analyze contractions

- Sort contractions by `startTime` (ascending = chronological).
- For each contraction compute **duration** = `endTime - startTime` (in seconds/minutes).
- Compute **interval** = time from previous contraction's `endTime` to current `startTime` (minutes). For the first contraction, interval is N/A.
- Summarize: count, time range of data, typical duration, typical interval, and any pattern (e.g. regular vs irregular).
- Apply safety rules from [references/schemas-and-thresholds.md](references/schemas-and-thresholds.md) (e.g. 5-1-1 rule, when to seek care).

### 3. Analyze baby logs

- From `birthday` and latest log timestamp, compute **baby's age** (e.g. days or weeks).
- Split `babyLog` by `type`: **feeding**, **diaper**, and **breastFeeding**.
- **Feeding** (bottle/expressed): extract `feedingDetails.volumeML` and `timestamp`. Compute total volume and feed count over last 24 h (and optionally last 48 h). Compute average volume per feed, average volume per hour (total mL / hours in window), and approximate interval between feeds.
- **BreastFeeding**: extract `breastFeedingDetails.durationSeconds` and `timestamp`. Compute session count and total duration (e.g. total minutes) over last 24 h (and optionally last 48 h). Optionally report average session length.
- **Diaper**: count wet (`diaperDetails.hasPee`), dirty (`diaperDetails.hasPoo`), and both. Compute counts over last 24 h (and optionally last 48 h).
- Compare to age-appropriate thresholds in [references/schemas-and-thresholds.md](references/schemas-and-thresholds.md) (feeds/sessions per day, wet/dirty diaper expectations).

### 4. Produce report and verdict

Output:

1. **Mum – Contraction summary**  
   Count, date range, duration/interval stats, pattern. Then: **Mum safe?** (Yes / Monitor / Seek care) with short reason and any next step (e.g. "Continue timing; if 5-1-1, go to hospital").

2. **Baby – Feeding & diaper summary**  
   Age; bottle feeds in last 24 h (count + total mL); breastfeeding sessions in last 24 h (count + total duration if present); diapers in last 24 h (wet/dirty). Then: **Baby healthy?** (Yes / Monitor / Concern) with short reason and any recommendation (e.g. "Ensure 8+ feeds and 6+ wet diapers per day").

3. **Caveat**  
   One line: this is not medical advice; when in doubt, contact a midwife, OB, or paediatrician.

## Output format

Use clear headings and bullet points. Lead with the two verdicts (mum safe? baby healthy?) then expand with numbers and brief reasoning. Keep the report scannable and under one screen where possible.
