import { z } from "zod";

export const OlvidAccountSchema = z
  .object({
    name: z.string().optional(),
    enabled: z.boolean().optional(),
    daemonUrl: z.string().optional(),
    clientKey: z.string().optional(),
  })
  .strict();

export const OlvidConfigSchema = OlvidAccountSchema.extend({
  accounts: z.record(z.string(), OlvidAccountSchema.optional()).optional(),
});
