---
slug: ollama-memory-embeddings
version: "1.0.4"
display_name: Ollama Memory Embeddings
displayName: Ollama Memory Embeddings
name: ollama-memory-embeddings
description: >
  Configure OpenClaw memory search to use Ollama as the embeddings server
  (OpenAI-compatible /v1/embeddings) instead of the built-in node-llama-cpp
  local GGUF loading. Includes interactive model selection and optional import
  of an existing local embedding GGUF into Ollama.
---

# Ollama Memory Embeddings

This skill configures OpenClaw memory search to use Ollama as the **embeddings
server** via its OpenAI-compatible `/v1/embeddings` endpoint.

> **Embeddings only.** This skill does not affect chat/completions routing —
> it only changes how memory-search embedding vectors are generated.

## What it does

- Installs this skill under `~/.openclaw/skills/ollama-memory-embeddings`
- Verifies Ollama is installed and reachable
- Lets the user choose an embedding model:
  - `embeddinggemma` (default — closest to OpenClaw built-in)
  - `nomic-embed-text` (strong quality, efficient)
  - `all-minilm` (smallest/fastest)
  - `mxbai-embed-large` (highest quality, larger)
- Optionally imports an existing local embedding GGUF into Ollama via
  `ollama create` (currently detects embeddinggemma, nomic-embed, all-minilm,
  and mxbai-embed GGUFs in known cache directories)
- Normalizes model names (handles `:latest` tag automatically)
- Updates `agents.defaults.memorySearch` in OpenClaw config (surgical — only
  touches keys this skill owns):
  - `provider = "openai"`
  - `model = <selected model>:latest`
  - `remote.baseUrl = "http://127.0.0.1:11434/v1/"`
  - `remote.apiKey = "ollama"` (required by client, ignored by Ollama)
- Performs a post-write config sanity check (reads back and validates JSON)
- Optionally restarts the OpenClaw gateway (with detection of available
  restart methods: `openclaw gateway restart`, systemd, launchd)
- Optional memory reindex during install (`openclaw memory index --force --verbose`)
- Runs a two-step verification:
  1. Checks model exists in `ollama list`
  2. Calls the embeddings endpoint and validates the response
- Adds an idempotent drift-enforcement command (`enforce.sh`)
- Adds optional config drift auto-healing watchdog (`watchdog.sh`)

## Install

```bash
bash ~/.openclaw/skills/ollama-memory-embeddings/install.sh
```

From this repository:

```bash
bash skills/ollama-memory-embeddings/install.sh
```

## Non-interactive usage

```bash
bash ~/.openclaw/skills/ollama-memory-embeddings/install.sh \
  --non-interactive \
  --model embeddinggemma \
  --reindex-memory auto
```

Bulletproof setup (install watchdog):

```bash
bash ~/.openclaw/skills/ollama-memory-embeddings/install.sh \
  --non-interactive \
  --model embeddinggemma \
  --reindex-memory auto \
  --install-watchdog \
  --watchdog-interval 60
```

> **Note:** In non-interactive mode, `--import-local-gguf auto` is treated as
> `no` (safe default). Use `--import-local-gguf yes` to explicitly opt in.

Options:

- `--model <id>`: one of `embeddinggemma`, `nomic-embed-text`, `all-minilm`, `mxbai-embed-large`
- `--import-local-gguf <auto|yes|no>`: default `no` (safer default; opt in with `yes`)
- `--import-model-name <name>`: default `embeddinggemma-local`
- `--restart-gateway <yes|no>`: default `no` (restart only when explicitly requested)
- `--skip-restart`: deprecated alias for `--restart-gateway no`
- `--openclaw-config <path>`: config file path override
- `--install-watchdog`: install launchd drift auto-heal watchdog (macOS)
- `--watchdog-interval <sec>`: watchdog interval (default 60)
- `--reindex-memory <auto|yes|no>`: memory rebuild mode (default `auto`)
- `--dry-run`: print planned changes and commands; make no modifications

## Verify

```bash
~/.openclaw/skills/ollama-memory-embeddings/verify.sh
```

Use `--verbose` to dump raw API response on failure:

```bash
~/.openclaw/skills/ollama-memory-embeddings/verify.sh --verbose
```

## Drift enforcement and auto-heal

Manually enforce desired state (safe to run repeatedly):

```bash
~/.openclaw/skills/ollama-memory-embeddings/enforce.sh \
  --model embeddinggemma \
  --openclaw-config ~/.openclaw/openclaw.json
```

Check for drift only:

```bash
~/.openclaw/skills/ollama-memory-embeddings/enforce.sh \
  --check-only \
  --model embeddinggemma
```

Run watchdog once (check + heal):

```bash
~/.openclaw/skills/ollama-memory-embeddings/watchdog.sh \
  --once \
  --model embeddinggemma
```

Install watchdog via launchd (macOS):

```bash
~/.openclaw/skills/ollama-memory-embeddings/watchdog.sh \
  --install-launchd \
  --model embeddinggemma \
  --interval-sec 60
```

## GGUF detection scope

The installer searches for embedding GGUFs matching these patterns in known
cache directories (`~/.node-llama-cpp/models`, `~/.cache/node-llama-cpp/models`,
`~/.cache/openclaw/models`):

- `*embeddinggemma*.gguf`
- `*nomic-embed*.gguf`
- `*all-minilm*.gguf`
- `*mxbai-embed*.gguf`

Other embedding GGUFs are not auto-detected. You can always import manually:

```bash
ollama create my-model -f /path/to/Modelfile
```

## Notes

- This does not modify OpenClaw package code. It only updates user config.
- A timestamped backup of config is written before changes.
- If no local GGUF exists, install proceeds by pulling the selected model from Ollama.
- Model names are normalized with `:latest` tag for consistent Ollama interaction.
- If embedding model changes, rebuild/re-embed existing memory vectors to avoid
  retrieval mismatch across incompatible vector spaces.
- With `--reindex-memory auto`, installer reindexes only when the effective
  embedding fingerprint changed (`provider`, `model`, `baseUrl`, `apiKey presence`).
- Drift checks require a non-empty apiKey but do not require a literal `"ollama"` value.
- Config backups are created only when a write is needed.
- Legacy schema fallback is supported: if `agents.defaults.memorySearch` is absent,
  the enforcer reads known legacy paths and mirrors writes to preserve compatibility.
