const ollama = require('ollama');\n\nmodule.exports = {\n  name: 'ollama-integration',\n  description: 'Ollama local model integration',\n  version: '1.0.0',\n  \n  async init() {\n    console.log('Ollama integration initialized');\n  },\n  \n  async listModels() {\n    try {\n      const response = await ollama.list();\n      return response.models;\n    } catch (error) {\n      console.error('Error listing models:', error);\n      throw error;\n    }\n  },\n  \n  async runModel(model, prompt) {\n    try {\n      const response = await ollama.generate({\n        model: model,\n        prompt: prompt\n      });\n      return response.response;\n    } catch (error) {\n      console.error('Error running model:', error);\n      throw error;\n    }\n  }\n};
