# Trading Rules

These are guiding principles for decision-making. They define **how to think**, not what to do.
The agent should observe the market, learn from outcomes, and continuously refine its own judgment.

---

## 1. Market Observation

Before any decision, understand the current market state:

- What is the trend across multiple timeframes (1H, 4H, 1D)? Are they aligned or conflicting?
- What are RSI, MACD, and moving averages indicating? Do they agree?
- What is the current trading volume relative to recent history?
- Is this a trending market or a ranging market? The answer changes how signals should be weighted.
- What is the funding rate for perpetual swaps? Extreme funding often precedes reversals.
- Are there signs of market exhaustion (e.g., strong trend with weakening volume)?

Observation is not about confirming a bias. It is about reading what the market is actually doing.

---

## 2. Decision Principles

- Act on evidence, not prediction. Do not assume what will happen; respond to what is happening.
- When signals across indicators and timeframes align, conviction is higher. When they conflict, reduce exposure or wait.
- A decision to wait is a valid decision. Forcing a trade when conditions are unclear is worse than doing nothing.
- Every trade should have a clear reason. If the reason cannot be articulated, the trade should not happen.
- Consider asymmetry: is the potential reward proportionate to the risk given current conditions?

---

## 3. Position Sizing

Size positions based on conviction derived from evidence, not from fixed rules:

- Higher alignment across signals and timeframes → can justify a larger position.
- Conflicting signals, uncertain regime, or recent consecutive losses → smaller position.
- The market will indicate how much confidence is warranted. Follow that, not a preset number.

---

## 4. Entry and Exit

- Enter when multiple indicators confirm the same direction. One signal alone is weak.
- Define an exit condition before entering. Know what would invalidate the trade thesis.
- Exit when the original reason for the trade no longer holds — not just because a price target is hit.
- If the market moves strongly against a position without a clear reason, that is information. Respond to it.

---

## 5. Self-Learning

After every trade — win or loss — ask:

- Was the entry based on sound reasoning at the time?
- What did the market do that was unexpected? Why?
- Did the exit happen for the right reason, or was it emotional?
- What would be done differently with the same setup?

Track recurring patterns in wins and losses. Over time, weight decisions toward conditions that have historically worked and away from conditions that have not.

---

## 6. Adaptation

- The market changes. A rule that worked in a trending market may fail in a ranging one.
- Do not rigidly apply past patterns. Use them as evidence, not as guarantees.
- If recent trades are consistently underperforming, do not increase size to recover. Step back, observe, and understand why before acting again.
- Be willing to change any assumption based on new evidence from the market.

---

## 7. Risk Awareness

Risk is not managed through fixed limits. It is managed through understanding:

- What is the realistic downside if this trade goes wrong?
- How does this position interact with existing positions? Does it concentrate or diversify risk?
- How liquid is this market? Can the position be exited quickly if needed?
- Is the current market environment (volatility, trend strength) suitable for the intended trade?

Risk awareness should be continuous, not a one-time check before entry.
