# OKR Workshop Facilitation Guide

## Pre-Workshop Prep

### 1 Week Before
- [ ] Confirm attendees and calendar holds
- [ ] Share pre-read: company strategy, last quarter's OKRs, any relevant data
- [ ] Send prompt: "Come prepared with your top 3 priorities for next quarter"
- [ ] Book room/Zoom with whiteboard capability

### 1 Day Before
- [ ] Prepare templates (digital or physical)
- [ ] Review previous quarter's scores and learnings
- [ ] Identify any known strategic shifts or constraints

---

## Workshop Agenda Templates

### Full OKR Setting Workshop (4 hours)

| Time | Activity | Duration |
|------|----------|----------|
| 0:00 | Welcome & Context Setting | 15 min |
| 0:15 | Last Quarter Retrospective | 30 min |
| 0:45 | Strategic Priorities Review | 20 min |
| 1:05 | Break | 10 min |
| 1:15 | Individual Brainstorm (silent) | 15 min |
| 1:30 | Share & Cluster Objectives | 30 min |
| 2:00 | Vote & Prioritize Top 3-5 | 20 min |
| 2:20 | Break | 10 min |
| 2:30 | Define Key Results (breakouts) | 45 min |
| 3:15 | Present & Critique KRs | 30 min |
| 3:45 | Finalize & Assign Owners | 15 min |

### Quick OKR Refresh (90 min)
For teams with established OKR practice:

| Time | Activity | Duration |
|------|----------|----------|
| 0:00 | Score Last Quarter (pre-filled) | 10 min |
| 0:10 | 3 Learnings, 3 Priorities | 20 min |
| 0:30 | Draft Objectives (pairs) | 20 min |
| 0:50 | Define Key Results | 25 min |
| 1:15 | Final Review & Dependencies | 15 min |

---

## Facilitation Techniques

### The "So What" Test
When someone proposes an objective or KR, ask "So what?" repeatedly:
- "We'll launch the new dashboard"
- "So what?"
- "So customers can see their usage"
- "So what?"
- "So they'll use the product more effectively"
- "So what?"
- "So retention improves"
- **Now you have an outcome**: "Improve customer retention by X%"

### Dot Voting
When prioritizing objectives:
1. Each person gets 3-5 dots
2. Can place multiple dots on one item (shows conviction)
3. Tally and discuss top 3-5
4. Facilitator can override ties with strategic lens

### The "Newspaper Test"
For each objective, ask: "If this were in the news at the end of the quarter, what would the headline be?"
- Bad: "Company Launches New Feature"
- Good: "Company's New Feature Drives 50% Increase in Customer Engagement"

### Red Team Exercise
After drafting OKRs, split into two groups:
- Group A: Defend the OKRs (why they're right)
- Group B: Attack the OKRs (why they'll fail)
- Swap and repeat
- Revise based on vulnerabilities exposed

---

## Common Workshop Pitfalls

| Pitfall | Prevention |
|---------|------------|
| HIPPO dominates (Highest Paid Person's Opinion) | Use silent brainstorm before discussion |
| Too many ideas, no focus | Strict dot voting, force rank |
| Vague KRs slip through | Dedicated critique round with "measurement police" |
| Dependencies ignored | Explicit "who depends on you / who do you depend on" exercise |
| No time for KRs | Protect KR time; better to have fewer, well-defined OKRs |

---

## Post-Workshop

### Within 24 Hours
- [ ] Send cleaned-up OKRs to all participants
- [ ] Flag any unresolved dependencies for follow-up
- [ ] Schedule first weekly check-in

### Within 1 Week
- [ ] Get explicit sign-off from all OKR owners
- [ ] Publish to shared OKR tracker (Discord, Notion, etc.)
- [ ] Share with broader org for transparency
