# OKR Templates

## Objective Template

```
OBJECTIVE: [Verb] [inspiring outcome] by [timeframe]

Example:
OBJECTIVE: Transform the company into an AI-powered organization by end of Q1
```

**Good objectives are:**
- Qualitative (not a number)
- Inspiring (people care)
- Time-bound (clear deadline)
- Achievable but stretchy
- Clear enough that someone outside the team understands

**Bad objectives:**
- "Improve customer satisfaction" (too vague)
- "Increase revenue by 20%" (that's a KR)
- "Be the best" (unmeasurable)

---

## Key Result Templates

### Increase/Decrease
```
Increase [metric] from [baseline] to [target] by [date]
Decrease [metric] from [baseline] to [target] by [date]

Examples:
- Increase NPS from 32 to 45 by March 31
- Decrease customer churn from 8% to 5% by end of Q1
```

### Achieve/Reach
```
Achieve [milestone/threshold] by [date]

Examples:
- Achieve SOC 2 Type II certification by March 31
- Reach $1M ARR by end of Q1
```

### Complete/Deliver
```
Complete [deliverable] with [quality criteria] by [date]

Examples:
- Complete migration to new EDI provider with zero customer-facing disruption
- Deliver mobile app v2.0 with >4.5 star rating in first 30 days
```

### Launch/Deploy
```
Launch [thing] to [audience] achieving [success metric]

Examples:
- Deploy AI notetaker to 100% of employees by March 31
- Launch pricing page with >10% visitor-to-trial conversion
```

---

## Full OKR Example

```
═══════════════════════════════════════════════════════════
OBJECTIVE 1: Establish AI as a Force Multiplier
═══════════════════════════════════════════════════════════

KR1: Deploy AI notetaker to 100% of employees by March 31
     Status: 🟡 | Progress: 60% | Confidence: 6/10
     Owner: Project Lead
     
KR2: Implement 3 AI workflow automations (delegated)
     Status: 🟡 | Progress: 2/3 | Confidence: 5/10
     Owner: Direct Report
     
KR3: Identify 5 new AI use cases from workshop participants
     Status: 🔴 | Progress: 0/5 | Confidence: 3/10
     Owner: Project Lead
     Blocker: Workshops not yet scheduled
     
KR4: Reduce spec sheet generation from 1hr to 5min (delegated)
     Status: 🟢 | Progress: 80% | Confidence: 8/10
     Owner: Direct Report
     
KR5: Gain ability to match distributors for all 4 major GPOs
     Status: 🟡 | Progress: 50% | Confidence: 5/10
     Owner: Lead + AI Assistant
═══════════════════════════════════════════════════════════
```

---

## Discord Channel Structure for OKRs

```
📁 #projects
   └── 🧵 OKR 1: AI & Automation (thread)
   └── 🧵 OKR 2: EDI Infrastructure (thread)
   └── 🧵 OKR 3: IT Modernization (thread)
   └── 🧵 OKR 4: $100K Cost Savings (thread)
```

Each thread contains:
1. **Pinned header** with current status table
2. **Weekly updates** as replies
3. **Discussion** of blockers, ideas, progress

---

## Weekly Update Template

```
📊 **[OKR Name] — Week [X] Update**

**Overall Status:** 🟡 At Risk | Score: 0.55

**KR Updates:**
- 🟢 **KR4**: [Brief update on what changed]
- 🟡 **KR1**: [Brief update]
- 🔴 **KR3**: [Brief update with blocker]

**Blockers:**
1. [Blocker 1] — Owner: [Name]
2. [Blocker 2] — Owner: [Name]

**Help Needed:**
- [Specific ask]

**Next Week Focus:**
- [Priority 1]
- [Priority 2]
```

---

## Monthly Summary Template

```
📈 **[Quarter] OKR Monthly Summary — [Month]**

**Scorecard:**
| OKR | Last Month | This Month | Trend |
|-----|------------|------------|-------|
| OKR 1 | 0.40 | 0.55 | ↑ |
| OKR 2 | 0.70 | 0.75 | ↑ |
| OKR 3 | 0.50 | 0.48 | ↓ |
| OKR 4 | 0.60 | 0.70 | ↑ |

**Highlights:**
- [Win 1]
- [Win 2]

**Concerns:**
- [Risk 1]
- [Risk 2]

**Forecast:**
- OKR 1: Likely 🟡 finish (0.6-0.7)
- OKR 2: On track for 🟢 (0.8+)
- OKR 3: At risk of 🔴 miss without intervention
- OKR 4: On track for 🟢 (0.7-0.8)
```

---

## End-of-Quarter Report Template

```
📋 **Q[X] 20XX OKR Final Report**

**Executive Summary:**
- Achieved [X] of [Y] OKRs at target (0.7+)
- Average score: [0.XX]
- Key wins: [1-2 sentences]
- Key misses: [1-2 sentences]

**Detailed Scores:**

| Objective | Final Score | Target | Result |
|-----------|-------------|--------|--------|
| OKR 1: AI & Automation | 0.68 | 0.70 | 🟡 Close |
| OKR 2: EDI Infrastructure | 0.82 | 0.70 | 🟢 Beat |
| OKR 3: IT Modernization | 0.55 | 0.70 | 🔴 Miss |
| OKR 4: $100K Savings | 0.73 | 0.70 | 🟢 Beat |

**Learnings:**
1. [What we learned]
2. [What we'd do differently]
3. [What worked well]

**Carry-Forward to Next Quarter:**
- [ ] [Item 1]
- [ ] [Item 2]
```
