# OKR Scoring Guide

## The 0.0–1.0 Scale (Google Standard)

| Score | Meaning | Interpretation |
|-------|---------|----------------|
| 1.0 | 100%+ | Crushed it (or sandbagged?) |
| 0.9 | 90% | Exceptional |
| 0.8 | 80% | Strong |
| **0.7** | **70%** | **Target for stretch goals** |
| 0.6 | 60% | Solid progress |
| 0.5 | 50% | Halfway |
| 0.4 | 40% | Struggled |
| 0.3 | 30% | Fell short |
| 0.2 | 20% | Major miss |
| 0.1 | 10% | Barely started |
| 0.0 | 0% | Nothing happened |

### The 0.7 Sweet Spot
For aspirational/moonshot OKRs, 0.7 is the ideal average:
- High enough to drive real impact
- Low enough to prove you stretched
- Pattern of all 1.0s = not ambitious enough
- Pattern of all 0.3s = goals too disconnected from reality

---

## Scoring Methods

### 1. Quantitative KRs (Easy)
Direct calculation based on target:

| KR Target | Actual | Score |
|-----------|--------|-------|
| Increase NPS from 32 to 45 (Δ13) | NPS = 42 (Δ10) | 10/13 = 0.77 |
| Reduce churn from 8% to 5% (Δ3) | Churn = 6% (Δ2) | 2/3 = 0.67 |
| Close $500K new revenue | Closed $400K | 400/500 = 0.80 |

### 2. Milestone KRs
For KRs with discrete stages:

| Milestone | Weight | Complete? | Score |
|-----------|--------|-----------|-------|
| Design complete | 0.2 | ✅ | 0.2 |
| Development complete | 0.3 | ✅ | 0.3 |
| QA passed | 0.2 | ✅ | 0.2 |
| Deployed to 50% users | 0.2 | ⬜ | 0 |
| 100% rollout | 0.1 | ⬜ | 0 |
| **Total** | | | **0.7** |

### 3. Binary KRs (Avoid When Possible)
If you must have yes/no:
- Done = 1.0
- Not done = 0.0
- Partial = qualitative judgment (0.3-0.7)

Better: Convert to measurable. "Launch feature" → "Launch feature with >90% uptime and <10 critical bugs in first 30 days"

---

## Confidence Scoring (During Quarter)

Use alongside progress scoring to predict outcomes:

| Confidence | Meaning | Action |
|------------|---------|--------|
| 9-10 | Virtually certain | Cruise, maybe stretch further |
| 7-8 | Highly likely | Stay the course |
| 5-6 | Coin flip | Identify specific risks |
| 3-4 | Unlikely without change | Escalate, get help |
| 1-2 | Miracle needed | Triage: save or abandon |

### Confidence vs. Progress
- **Progress** = How far have we come? (backward-looking)
- **Confidence** = How likely to hit target? (forward-looking)

You can have:
- High progress, low confidence (80% done but blocker ahead)
- Low progress, high confidence (slow start but clear path)

---

## Team/Org Roll-ups

### Simple Average
Average all KR scores for an Objective:
- KR1: 0.8, KR2: 0.6, KR3: 0.7
- Objective Score: (0.8 + 0.6 + 0.7) / 3 = **0.70**

### Weighted Average
If some KRs matter more:
- KR1 (weight 50%): 0.8 → 0.40
- KR2 (weight 30%): 0.6 → 0.18
- KR3 (weight 20%): 0.7 → 0.14
- Objective Score: **0.72**

### Company Score
Average of all Objective scores (or weighted by strategic priority).

---

## When to Adjust Targets

### Green Light to Adjust
- External shock (market crash, pandemic, major customer loss)
- Strategic pivot from leadership
- Discovered original target was based on bad data

### Red Light — Don't Adjust
- "It's harder than we thought" (that's learning)
- "Priorities shifted" (without leadership mandate)
- "We're not going to hit it" (accept the score, learn from it)

### How to Adjust
If adjustment is warranted:
1. Document original target and reason for change
2. Set new target with clear rationale
3. Note adjustment in final scoring ("Adjusted from X to Y mid-quarter due to Z")
4. Don't retroactively pretend the new target was always the goal

---

## Scoring Calibration Session

At end of quarter, before finalizing:

1. **Self-score first** — Each owner proposes their own scores
2. **Peer review** — Others challenge or validate
3. **Evidence check** — "Show me the data"
4. **Consistency check** — Are we scoring similarly across teams?
5. **Lock scores** — Final numbers recorded

### Calibration Questions
- "Would another team score this the same way?"
- "What's the evidence for this score?"
- "Are we being too hard or too easy on ourselves?"
