# OKR Philosophy & Origins

## History

**Andy Grove (Intel, 1970s)** — Created "iMBOs" (Intel Management by Objectives), evolving Peter Drucker's MBO framework. Grove added the crucial innovation: measurable Key Results.

**John Doerr (Google, 1999)** — Brought OKRs to Google as an early investor/advisor. Wrote "Measure What Matters" (2018), the definitive OKR guide.

**Modern adoption**: Google, LinkedIn, Twitter, Spotify, Airbnb, Netflix, and thousands of startups and enterprises.

## The Four OKR Superpowers (from Measure What Matters)

John Doerr identifies four "superpowers" that OKRs unlock:

### Superpower #1: Focus and Commit to Priorities
OKRs force prioritization. If everything is important, nothing is. Limit to 3-5 objectives maximum. The discipline of choosing is the point.

**Key insight**: Leaders must say "no" to many good ideas to enable focus on the few great ones.

### Superpower #2: Align and Connect for Teamwork
- **Vertical**: Individual → Team → Company OKRs should ladder up
- **Horizontal**: Cross-functional dependencies should be visible
- **Not cascade**: OKRs shouldn't be dictated top-down; teams have input on "how"

**Key insight**: Public OKRs create transparency. When everyone can see what everyone else is working on, silos break down.

### Superpower #3: Track for Accountability
What gets measured gets managed. Weekly check-ins keep OKRs alive. Without regular tracking, they become "set and forget."

**Key insight**: Regular check-ins catch problems early. A 6-week surprise is much worse than a week-3 course correction.

### Superpower #4: Stretch for Amazing
Aim for 60-70% achievement. If you're hitting 100%, you're not being ambitious enough. "Moonshots" should feel uncomfortable.

**Key insight**: Stretch goals attract top talent and create the most exciting work environments. Even "failed" moonshots often produce substantial advancements.

---

## Transparency as Foundation
All OKRs should be visible to the entire org. This creates accountability and surfaces misalignments early. As Twitter's former CEO Dick Costolo said: "OKRs are a great way to communicate strategy and how you're going to measure strategy."

## OKRs vs. Other Frameworks

| Framework | Focus | Cadence | Best For |
|-----------|-------|---------|----------|
| **OKRs** | Outcomes & stretch goals | Quarterly | Ambitious orgs, innovation |
| **KPIs** | Ongoing performance | Continuous | BAU operations, health metrics |
| **SMART Goals** | Individual achievement | Variable | Personal development |
| **Balanced Scorecard** | Multi-dimensional strategy | Annual | Enterprise strategy |
| **V2MOM** | Salesforce's vision alignment | Annual | Top-down strategy |

**Key distinction**: OKRs are for *change* and *stretch*. KPIs are for *maintaining* and *monitoring*. Don't use OKRs for business-as-usual.

## The Two Types of OKRs

### Committed OKRs (Roofshots)
- Must-hit targets tied to business requirements
- Expected 100% completion
- Often tied to customer commitments, compliance, revenue targets
- Failure has real consequences

### Aspirational OKRs (Moonshots)
- Stretch goals that push boundaries
- Expected 60-70% completion
- Encourages innovation and risk-taking
- "Failure" still produces valuable progress

**Best practice**: Be explicit about which type each OKR is. Mixed signals cause frustration.

## Why OKRs Fail

1. **No executive sponsorship** — OKRs die without leadership commitment
2. **Too many OKRs** — Dilutes focus, becomes a task list
3. **Tied to compensation** — Incentivizes sandbagging
4. **Set and forget** — No regular check-ins
5. **Outputs vs. outcomes** — "Launch X" instead of "Achieve Y through X"
6. **No psychological safety** — Fear of failure kills ambition

## Why OKRs Work

1. **Creates clarity** — Everyone knows what matters
2. **Enables autonomy** — Teams own the "how"
3. **Surfaces blockers early** — Regular check-ins catch problems
4. **Builds alignment** — Cross-functional visibility
5. **Encourages ambition** — Stretch goals push limits
6. **Provides learning loops** — Retrospectives improve over time
