# OKR Check-in Cadences & Templates

## The Check-in Rhythm

```
        Week 1    Week 2    Week 3    Week 4    ...    Week 12
          │         │         │         │                  │
          ▼         ▼         ▼         ▼                  ▼
        [Weekly] [Weekly] [Weekly] [Weekly]           [Weekly]
                    │                   │                  │
                    ▼                   ▼                  ▼
                [Monthly]          [Monthly]          [EOQ Retro]
```

---

## Weekly Check-in (15 min)

### Format: Traffic Light + Confidence

For each Key Result:

| KR | Status | Confidence | Update |
|----|--------|------------|--------|
| KR1: Increase NPS from 32 to 45 | 🟡 | 6/10 | Survey going out Friday, expect data next week |
| KR2: Reduce churn to <5% | 🟢 | 8/10 | Currently at 4.2%, on track |
| KR3: 3 case studies published | 🔴 | 3/10 | Only 1 complete, 2 customers ghosted |

### The Three Questions
1. **What's your confidence (0-10) that you'll hit this KR?**
2. **What's the biggest blocker right now?**
3. **What help do you need?**

---

## Fist-to-Five Voting (From Spotify Retro Kit)

A fast, visual way to gauge team confidence:

**How it works:**
1. For each Key Result, ask: "How confident are you we'll deliver this?"
2. On count of three, everyone holds up fingers:
   - ✊ Fist = 0% confidence (we're not going to make it)
   - 1️⃣ One finger = ~20% confidence
   - ✌️ Two fingers = ~40% confidence
   - 3️⃣ Three fingers = ~60% confidence
   - 4️⃣ Four fingers = ~80% confidence
   - 🖐 Five fingers = 100% confidence (we've got this)

**Why simultaneous voting matters:**
- Prevents groupthink (everyone doesn't just agree with the lead)
- Surfaces diversity of opinion
- Creates space for discussion when votes differ

**After voting:**
1. Notice the spread — celebrate disagreement as valuable data!
2. Ask high voters: "What have you observed that gives you confidence?"
3. Ask low voters: "What concerns you?"
4. Capture observations briefly
5. Optionally re-vote to see if consensus improves
6. Agree on a number the group can live with for the week

**Key insight:** Don't rush to consensus. When you see fists and fives in the same vote, that's an invitation for a valuable team conversation.

---

## Confidence vs. Progress: Know the Difference

| | Progress | Confidence |
|---|---|---|
| **Looks at** | Past (how far have we come?) | Future (will we hit the target?) |
| **Measures** | Work completed | Likelihood of success |
| **Example** | "We're 80% done" | "I'm 50% confident we'll hit it" |

**Why both matter:**
- High progress, low confidence = "We're 80% done but there's a major blocker ahead"
- Low progress, high confidence = "Slow start but we have a clear path to finish"

**In check-ins, lead with confidence.** Progress is usually obvious from metrics. Confidence surfaces the "why" and "what next."

### AI Assistant Weekly Prompts
Send these on Monday mornings:

> "Quick OKR pulse check! For each of your KRs:
> - 🟢 On track (7-10 confidence)
> - 🟡 At risk (4-6 confidence)
> - 🔴 Off track (0-3 confidence)
> 
> What's your status and what do you need?"

---

## Monthly Review (30-60 min)

### Agenda

| Time | Activity |
|------|----------|
| 0:00 | Scorecard review (5 min) |
| 0:05 | Deep dive on yellows and reds (15 min) |
| 0:20 | Cross-team dependencies check (10 min) |
| 0:30 | Adjustments & action items (10 min) |

### Key Questions
- "What moved from green to yellow/red this month? Why?"
- "What's the trajectory if nothing changes?"
- "Are there any dependencies that are blocking you?"
- "Should we adjust scope or timeline? (Note: don't move goalposts lightly)"

---

## Mid-Quarter Review (Week 6-7)

This is the "last chance to course correct" checkpoint.

### Format
1. **Score each KR as if the quarter ended today** (0.0-1.0)
2. **Honest assessment**: "On current trajectory, where do we land?"
3. **Triage**:
   - 🟢 Keep pushing
   - 🟡 Needs intervention — what specifically?
   - 🔴 At risk of miss — escalate, reallocate, or accept

### Questions to Ask
- "If you had to bet money, would you hit this KR?"
- "What would need to be true to turn this around?"
- "Is this a resource problem, a priority problem, or a goal problem?"

---

## End-of-Quarter Retrospective (2-3 hours)

### Prep
- Pre-fill scores (owner self-scores, then discuss)
- Gather data/evidence for each KR
- Review original OKR rationale

### Agenda

| Time | Activity |
|------|----------|
| 0:00 | Individual scoring (pre-work or 15 min silent) |
| 0:15 | Walk through each OKR: score, evidence, story |
| 1:00 | Break |
| 1:10 | Retrospective discussion |
| 1:40 | Extract lessons for next quarter |
| 2:00 | Preview next quarter's priorities |

### Retrospective Questions
- "What went better than expected? Why?"
- "What went worse than expected? Why?"
- "What did we learn about our assumptions?"
- "What would we do differently?"
- "What should we carry forward vs. drop?"

---

## Async Check-in Formats

### Discord Thread Update (Weekly)
```
📊 **OKR Update — Week 6**

**KR1: Deploy AI notetaker to 100%**
Status: 🟡 (6/10)
Progress: 60% of employees onboarded
Blocker: IT ticket backlog for new hires

**KR2: 3 AI workflow automations**
Status: 🟢 (8/10)
Progress: 2 complete, 1 in testing
Next: QA signoff by Friday
```

### Confidence Emoji Scale
For quick async updates:
- 🟢 = 7-10 (on track, high confidence)
- 🟡 = 4-6 (at risk, needs attention)
- 🔴 = 0-3 (off track, needs intervention)
- ⚪ = Not started / no update

---

## Automated Check-in Prompts

### Monday Morning (via Telegram or Discord)
> "Happy Monday! Quick OKR check:
> Which of your KRs are 🟢, 🟡, or 🔴 this week?"

### Friday Wrap (optional)
> "EOW pulse: Did anything change on your OKRs this week? Any blockers for next week?"

### Mid-Quarter Nudge (Week 6)
> "We're halfway through Q1! Time for a mid-quarter reality check. How confident are you in each KR right now?"
