# CFRs: Conversations, Feedback, Recognition

## The Secret Sauce (from Measure What Matters)

John Doerr calls CFRs the "siblings" to OKRs. While OKRs tell you *what* to achieve, CFRs are *how* you support the humans achieving it.

**OKRs without CFRs = "set and forget"**
**OKRs with CFRs = continuous learning organization**

---

## The Three Components

### Conversations
Regular, authentic exchanges about work progress.

**What they are:**
- Ongoing dialogues about OKR progress, tactics, blockers
- Back-and-forth between managers and contributors
- NOT annual reviews; these happen weekly/bi-weekly

**Key questions:**
- "What's the status of your OKRs?"
- "Has there been any progress since we last talked?"
- "Is there anything blocking success?"
- "What help do you need?"

**Best practices:**
- Keep non-judgmental tone
- Focus on support, not scrutiny
- Document learnings for future reference
- Make it routine, not ad-hoc

---

### Feedback
Bidirectional communication to close the gap between intention and action.

**What it is:**
- Not just top-down criticism
- Two-way: employees → managers AND managers → employees
- Specific, constructive, and action-oriented

**Key questions:**
- Manager to team: "How can I better support you?"
- Team to manager: "What do you need from me to succeed?"
- Cross-team: "What could we do differently together?"

**Best practices:**
- Be specific: "The summary you wrote helped everyone understand the challenge" beats "good job"
- Be timely: Don't wait for end-of-quarter
- Rephrase complaints as requests: "Try presenting more slowly" beats "that presentation was bad"
- Make it safe: Psychological safety enables honest feedback

**Avoid:**
- Vague feedback ("be better")
- Delayed feedback (annual reviews only)
- One-directional feedback (only manager → employee)
- Public criticism (praise publicly, correct privately)

---

### Recognition
Positive, real-time acknowledgment of contributions.

**What it is:**
- Celebrating wins, big and small
- Affirming behaviors you want to see more of
- Building morale and motivation

**Key principles:**
- **Timely**: Don't wait for formal ceremonies
- **Specific**: "Your detailed analysis saved us from a bad decision" beats "thanks"
- **Public when appropriate**: Peer and team recognition amplifies impact
- **Frequent**: Small acknowledgments matter as much as big awards

**Recognition sources:**
- Manager → direct report (traditional)
- Peer → peer (often more meaningful)
- Team → team (cross-functional appreciation)
- Public channels (Discord, Slack, newsletters)

**What to recognize:**
- Progress on OKRs, even partial
- Helping others with their OKRs
- Surfacing problems early
- Creative problem-solving
- Going above and beyond

---

## CFRs in Practice

### Weekly Rhythm
| Day | Activity |
|-----|----------|
| Monday | Check-in conversation (15 min) |
| Throughout week | Real-time feedback as needed |
| Friday | Quick recognition/wins (async or standup) |

### Monthly Deep Dive
- 30-60 min 1:1 with deeper conversation
- Review OKR progress together
- Exchange feedback both directions
- Plan recognition for team contributions

### Quarterly
- Formal retrospective with all CFR components
- Team-wide recognition ceremony
- Capture lessons for next cycle

---

## CFRs for Remote/Hybrid Teams

When teams are distributed:

**Conversations:**
- Video > audio > text (face-to-face builds connection)
- Regular 1:1 schedule (don't let it slip)
- Document discussions for async team members

**Feedback:**
- Written feedback provides clarity
- Follow up written feedback with verbal discussion
- Be extra explicit (tone is lost in text)

**Recognition:**
- Public channels (Discord, Slack) for visibility
- Virtual celebrations (emoji reactions, gifs, shoutouts)
- Surprise recognition (unexpected is more impactful)

---

## Why CFRs Matter for OKR Success

| Without CFRs | With CFRs |
|-------------|-----------|
| Goals feel imposed | Goals feel owned |
| Problems surface late | Blockers caught early |
| Failure feels punitive | Failure feels safe |
| Recognition is rare | Appreciation is constant |
| Learning is annual | Learning is continuous |

---

## Integration with OKR Cadences

| OKR Activity | CFR Integration |
|-------------|-----------------|
| Setting OKRs | Conversation: Discuss priorities, concerns |
| Weekly check-in | Conversation: Status, blockers, support |
| Mid-quarter review | Feedback: What's working, what's not |
| End-of-quarter | All three: Reflect, learn, celebrate |

---

## AI Assistant CFR Prompts

**For conversations:**
> "Quick sync on your top OKR. What's your confidence level and what do you need?"

**For feedback:**
> "One thing that's working well: [specific observation]. One thing to consider: [specific suggestion]."

**For recognition:**
> "🎉 Shoutout to [name] for [specific contribution] — this directly moved us forward on [OKR]!"
