# OKR Antipatterns & How to Fix Them

## 🚨 The Classic 6 (from Google's OKR Playbook)

These are the official antipatterns from whatmatters.com/Google's OKR playbook:

### 1. Failing to Differentiate Committed vs. Aspirational
- Marking a committed OKR as aspirational = teams don't take it seriously
- Marking an aspirational OKR as committed = defensiveness and priority inversion
- **Fix**: Be explicit about which type each OKR is. Different expectations, different scoring.

### 2. Business-as-Usual OKRs
- OKRs based on "what we can achieve without changing anything"
- No stretch, no innovation, no push
- **Fix**: Ask "What could our world look like if we were freed from most constraints?"

### 3. Timid Aspirational OKRs
- Starting from current state and asking "what if we got lucky?"
- Missing the transformative potential
- **Fix**: Start with the desired end state, then work backward. Aspirational means you don't know how to achieve it when you set it.

### 4. Sandbagging
- Team can meet all OKRs without using all resources
- Hoarding headcount or not pushing hard enough
- **Fix**: Committed + aspirational OKRs should consume slightly MORE than available resources. Celebrate 70% as success.

### 5. Low-Value Objectives ("Who Cares?" OKRs)
- Even if completed at 1.0, no one notices or cares
- Example: "Increase CPU utilization by 3%" (no user benefit)
- **Fix**: Ask "Could this get a 1.0 without providing end-user or economic benefit?" Reword to focus on tangible value.

### 6. Insufficient Key Results
- KRs are necessary but not sufficient to achieve the Objective
- Avoids the hard commitments; delays resource discovery
- **Fix**: Litmus test: "Could we score 1.0 on all KRs and still not achieve the Objective intent?" If yes, add/rework KRs.

---

## 🚨 The Big 10 Mistakes

### 1. Too Many OKRs
**Symptom**: 8+ objectives, 20+ key results
**Why it happens**: Fear of missing something, inability to prioritize
**Fix**: Force rank. Ask "If you could only do ONE thing, what would it be?" Then add 2-3 more at most.

### 2. Confusing Tasks with Key Results
**Symptom**: "Launch new website" instead of "Increase conversion rate by 15%"
**Why it happens**: Easier to track outputs than outcomes
**Fix**: Ask "So what? What does launching the website actually achieve?"

### 3. Sandbagging (Easy Goals)
**Symptom**: 100% completion every quarter
**Why it happens**: Fear of failure, tied to compensation
**Fix**: Celebrate 70% as success. Explicitly reward ambitious misses over safe hits.

### 4. No Regular Check-ins
**Symptom**: OKRs reviewed only at end of quarter
**Why it happens**: "Too busy doing the work"
**Fix**: Calendar-block 15-min weekly OKR check-ins. Non-negotiable.

### 5. Top-Down Cascade Without Input
**Symptom**: Teams receive OKRs dictated from above
**Why it happens**: Efficiency over engagement
**Fix**: Leadership sets direction (Objectives); teams propose Key Results and timelines.

### 6. Linking OKRs to Compensation
**Symptom**: Bonuses tied to OKR scores
**Why it happens**: Seems like "accountability"
**Fix**: Separate completely. Use OKRs for learning and alignment, use other systems for performance.

### 7. Binary Key Results
**Symptom**: "Yes/No" outcomes (Ship feature: Done/Not Done)
**Why it happens**: Lazy goal-setting
**Fix**: Add a spectrum. "Ship feature with >90% customer satisfaction and <5% churn"

### 8. Measuring Inputs Instead of Outcomes
**Symptom**: "Hold 10 customer meetings" instead of "Close $500K in new revenue"
**Why it happens**: Inputs are controllable
**Fix**: Ask "Why are you holding those meetings? What result do you want?"

### 9. Ignoring Dependencies
**Symptom**: Team A's OKR depends on Team B, but Team B doesn't know
**Why it happens**: Silos, poor communication
**Fix**: Explicit dependency mapping. When setting OKRs, ask "Who do you need? Who needs you?"

### 10. Moving Goalposts Mid-Quarter
**Symptom**: Targets change when things get hard
**Why it happens**: Discomfort with failure
**Fix**: Lock targets. If truly wrong, add a note explaining the change, but don't just quietly revise.

---

## 🔧 Quick Diagnosis

| If you see... | The problem is likely... | Ask... |
|---------------|-------------------------|--------|
| All green, every quarter | Sandbagging | "What would a stretch look like?" |
| All red, every quarter | Overcommitment or wrong goals | "Were these ever achievable?" |
| No updates for weeks | Lack of ownership or relevance | "Is this still the priority?" |
| Vague KRs | Output focus, not outcome | "How will you measure success?" |
| Surprise misses at EOQ | No tracking cadence | "When did you know this was at risk?" |

---

## 🛠 Recovery Playbook

### If OKRs are ignored:
1. Shrink scope radically (2 objectives max)
2. Make check-ins painfully short (10 min, Mondays)
3. Celebrate small wins publicly

### If OKRs feel like busywork:
1. Audit: Are these connected to strategy?
2. Reduce: Fewer, bolder OKRs
3. Empower: Let teams own the "how"

### If teams are gaming the system:
1. Remove compensation link
2. Publicly celebrate ambitious failures
3. Share learning stories, not just success stories
