---
name: okr-consulting
description: Manage, consult on, and optimize OKRs (Objectives and Key Results). Use when helping set, track, review, score, or improve OKRs. Covers OKR philosophy, common antipatterns, cadence management, scoring, visualization, check-ins, and retrospectives. Provides coaching prompts, workshop facilitation guidance, and dashboard design patterns.
---

# OKR Consulting Skill

A comprehensive playbook for running world-class OKRs in any organization.

## Quick Reference

**OKR = Objective + Key Results**
- **Objective**: Qualitative, inspirational, time-bound ("What do we want to achieve?")
- **Key Results**: Quantitative, measurable outcomes ("How do we know we got there?")
- **Rule of thumb**: 3-5 Key Results per Objective, 3-5 Objectives per quarter

**Scoring (Google-style 0.0–1.0):**
- 🟢 0.7–1.0 = Nailed it
- 🟡 0.4–0.6 = Made progress
- 🔴 0.0–0.3 = Missed

**Sweet spot**: Average 60-70% completion. If you're hitting 100%, you're sandbagging.

## Core Cadences

| Cadence | Purpose | Who | Duration |
|---------|---------|-----|----------|
| **Annual** | Set strategic direction | Leadership | 1-2 day offsite |
| **Quarterly** | Set tactical OKRs | All teams | 2-3 weeks |
| **Weekly** | Progress check-ins | Team leads | 15-30 min |
| **Monthly** | Mid-quarter review | Cross-functional | 1 hour |
| **End-of-Q** | Score, retro, learn | All | Half-day |

## My Role as OKR Consultant

### During OKR Setting
- Challenge vague objectives ("What does 'improve' mean?")
- Push for measurable KRs ("How will you know?")
- Flag too many OKRs ("Which 3 matter most?")
- Check vertical alignment ("Does this ladder up?")
- Check horizontal dependencies ("Who else needs to succeed?")

### During the Quarter
- Weekly: Prompt for confidence updates
- Bi-weekly: Surface at-risk KRs
- Monthly: Facilitate mid-quarter review
- Ongoing: Track blockers and escalate

### End of Quarter
- Prompt for self-scoring
- Facilitate retrospective discussion
- Extract lessons for next cycle
- Archive and document

## References

Detailed guidance in `references/`:
- **[philosophy.md](references/philosophy.md)** — Origins, Four Superpowers, why OKRs work
- **[antipatterns.md](references/antipatterns.md)** — Google's Classic 6 + Big 10 mistakes
- **[cfrs.md](references/cfrs.md)** — Conversations, Feedback, Recognition (the "secret sauce")
- **[workshops.md](references/workshops.md)** — Facilitation guides for OKR-setting sessions
- **[check-ins.md](references/check-ins.md)** — Weekly check-ins, fist-to-five voting, templates
- **[scoring.md](references/scoring.md)** — How to score, when to adjust, confidence ratings
- **[visualization.md](references/visualization.md)** — Dashboard patterns, display methods
- **[templates.md](references/templates.md)** — OKR templates for Discord, docs, slides

## Quick Coaching Prompts

**When setting OKRs:**
- "If you could only accomplish ONE thing this quarter, what would it be?"
- "How will you know you succeeded? What's the number?"
- "Is this a 'must-hit' commitment or a 'shoot for the moon' stretch?"
- "Who else depends on this? Who do you depend on?"

**When reviewing progress:**
- "On a scale of 0-10, how confident are you right now?"
- "What's the single biggest blocker?"
- "If this stays on current trajectory, where do you land?"
- "What would need to change to go from yellow to green?"

**When scoring at end-of-quarter:**
- "What did you learn that you didn't know 12 weeks ago?"
- "If you had to do this OKR again, what would you do differently?"
- "Was the goal right but execution off, or was the goal wrong?"

## Key Sources

This skill synthesizes knowledge from:
- **Measure What Matters** by John Doerr (2018) — The definitive OKR book
- **Google's OKR Playbook** (re:Work) — Google's internal best practices
- **whatmatters.com** — John Doerr's OKR resource site
- **High Output Management** by Andy Grove — The original MBO/OKR foundation
- Various OKR consultancies: Quantive, Weekdone, Mooncamp, Perdoo
