# Presentations Deep Dive

## Slide Design Principles

**Content rules:**
- One idea per slide
- 6x6 rule: max 6 bullets, max 6 words per bullet
- Headlines tell the story (someone skimming titles should get the point)
- Use images over text when possible

**Visual hierarchy:**
- Title: largest, top
- Key point: prominent
- Supporting details: smaller, less prominent
- Source/footnote: smallest, bottom

---

## Slide Master

**What it does:** Defines default layouts, fonts, colors, logo placement.

**Access:** View → Slide Master

**Changes here apply to all slides:**
- Add company logo to master = appears on all slides
- Change title font = all titles update
- Set background = consistent throughout

**Multiple layouts:** Create different masters for title slides, content slides, section headers.

---

## Animations

### Types
- **Entrance:** How element appears (Fade, Fly In, Appear)
- **Exit:** How element disappears
- **Emphasis:** Draw attention (Pulse, Grow/Shrink)
- **Motion Path:** Move element along path

### Best Practices
- Subtle over flashy (Fade > Bounce)
- Consistent animation style throughout
- Purpose: guide attention, not entertain
- Test timing before presenting

### Build Effect (Bullets one by one)
1. Select text box
2. Animations → Add Animation → choose effect
3. Effect Options → By Paragraph
4. Set to "On Click" or "After Previous"

---

## Presenter Tools

**Presenter View:**
- You see: current slide, next slide, notes, timer
- Audience sees: only current slide
- Enable: Slide Show → Use Presenter View

**Rehearse Timings:** Practice run that records time per slide.

**Laser Pointer:** Hold Ctrl + click during presentation.

**Black/White screen:** Press B (black) or W (white) during presentation.

---

## Charts & Data

**Link to Excel:**
1. Copy chart from Excel
2. PowerPoint → Paste Special → Paste Link
3. Updates when Excel data changes

**Animate charts:**
- Select chart
- Animations → Effect Options → By Series or By Category
- Reveals data progressively

---

## Export Options

| Format | Use Case |
|--------|----------|
| PDF | Share without editing, print |
| Video (MP4) | Self-running presentations, share online |
| Images (PNG/JPG) | Individual slides for social media |
| Handouts | Print multiple slides per page |
| Notes Pages | Print with speaker notes |

---

## Common Problems

| Problem | Solution |
|---------|----------|
| Fonts change on other computer | Embed fonts: File → Options → Save → Embed fonts |
| Video doesn't play | Use MP4 format, embed in file not link |
| File too large | Compress images: File → Compress Pictures |
| Animations out of order | Animation Pane → drag to reorder |

---

## Keyboard Shortcuts (PowerPoint)

| Action | Windows | Mac |
|--------|---------|-----|
| Start from beginning | F5 | Cmd+Shift+Enter |
| Start from current | Shift+F5 | Cmd+Enter |
| End slideshow | Esc | Esc |
| Next slide | Space/Enter | Space/Enter |
| Previous slide | Backspace | Delete |
| Go to slide N | Type N + Enter | Type N + Enter |
