# Office Administration

## Supplies Management

### Tracking System
Simple spreadsheet columns:
- Item name
- Current quantity
- Reorder point (trigger level)
- Preferred supplier
- Unit cost
- Last order date

### Reorder Process
1. Weekly check against reorder points
2. Consolidate orders to same supplier (bulk discount)
3. Track delivery, update inventory on arrival
4. Review usage patterns quarterly (adjust reorder points)

### Common Supplies Checklist
- [ ] Printer paper, ink/toner
- [ ] Pens, notebooks, sticky notes
- [ ] Kitchen: coffee, tea, snacks, cleaning supplies
- [ ] Bathroom: soap, paper products
- [ ] First aid kit (check expiry dates)

---

## Vendor Management

### Key Vendors to Manage
- Cleaning service
- IT support / managed services
- Office equipment maintenance (copier, HVAC)
- Catering (for meetings)
- Security / access control

### Contract Documentation
For each vendor, maintain:
- Contract copy with terms
- SLA (service level agreement)
- Primary contact + escalation contact
- Payment terms and schedule
- Renewal date (calendar reminder 60 days before)

### Performance Tracking
- Log service issues and resolution time
- Quarterly review: are they meeting SLA?
- Document issues for renegotiation leverage

---

## Space Planning

### Meeting Room Management
- Clear naming convention (avoid confusion)
- Booking system (shared calendar, dedicated app)
- Rules: release room if not using, 5-min buffer between meetings
- Equipment check: projector, whiteboard, video conferencing

### Hot Desking
- Booking system for desks
- Clean desk policy at end of day
- Lockers for personal items
- Ensure adequate power/network at all desks

### Visitor Management
- Sign-in process (paper log or digital)
- Visitor badges
- NDA for sensitive areas if needed
- Clear guest WiFi access

---

## Facilities Issues

### Common Problems & Contacts
| Issue | Who to Call |
|-------|------------|
| HVAC (too hot/cold) | Building management or HVAC contractor |
| Electrical | Electrician (have emergency contact) |
| Plumbing | Plumber |
| Security/access | Building security or locksmith |
| Cleaning issues | Cleaning service manager |

### Emergency Preparedness
- Fire extinguisher locations known
- Evacuation routes posted
- Emergency contacts list visible
- First aid trained staff identified

---

## Budget Tracking

### Monthly Categories
- Supplies
- Vendor services
- Equipment maintenance
- Utilities (if responsible)
- Miscellaneous

### Cost Control
- Negotiate annual contracts (better rates)
- Review subscriptions quarterly (cancel unused)
- Compare suppliers annually
- Track spending vs budget monthly

---

## Communication

### Regular Updates to Staff
- New vendor contacts
- Policy changes (parking, kitchen, meetings)
- Scheduled maintenance affecting access
- Holiday closures

### Feedback Collection
- Anonymous suggestion box (physical or digital)
- Quarterly survey on office environment
- Act on common complaints (builds trust)
