---
name: office365-connector
description: Office 365 / Outlook connector for email (read/send), calendar (read/write), and contacts (read/write) using resilient OAuth authentication. NOW WITH MULTI-ACCOUNT SUPPORT! Manage multiple Microsoft 365 identities from a single skill. Solves the difficulty connecting to Office 365 email, calendar, and contacts. Uses Microsoft Graph API with comprehensive Azure App Registration setup guide. Perfect for accessing your Microsoft 365/Outlook data from OpenClaw.
---

# Office 365 Connector (Multi-Account Enhanced)

## Overview

This skill provides resilient, production-ready connection to **Office 365 / Outlook** services including email, calendar, and contacts. **Now with multi-account support** (v2.0.0), you can manage multiple Microsoft 365 identities (work, personal, consulting, etc.) from a single skill installation.

It solves the common challenge of connecting to Office 365 from automation tools by providing OAuth authentication, automatic token refresh, per-account isolation, and comprehensive Azure App Registration setup guidance.

**Perfect for:**
- Managing multiple work identities across organizations
- Separating personal and professional email/calendar
- Accessing shared mailboxes and delegated calendars
- Consultants and freelancers working across multiple clients

**New in v2.0.0:** Multi-account support! See [MULTI-ACCOUNT.md](MULTI-ACCOUNT.md) for complete usage guide.

**Attribution:** Enhanced by **Matthew Gordon** ([matt@workandthrive.ai](mailto:matt@workandthrive.ai)) - See [CREDITS.md](CREDITS.md) for full attribution.

## What's New in v2.0.0

**Major Enhancements by Matthew Gordon:**

- ✨ **Multi-Account Management** - Handle multiple Microsoft 365 identities from one skill
- 🔐 **Per-Account Token Isolation** - Separate, secure token storage for each account
- 🔄 **Easy Account Switching** - Use `--account=name` flag across all operations
- ⚙️ **Default Account Selection** - Set your preferred account for convenience
- 📦 **Legacy Import Tool** - Migrate existing single-account setups seamlessly
- 🎯 **Account Management CLI** - Simple add/remove/list/default commands
- ✅ **Full Backward Compatibility** - Existing single-account setups work unchanged

See [CHANGELOG.md](CHANGELOG.md) for complete version history.

## Capabilities

### Email Operations
- Read emails (inbox, sent items, folders)
- Send emails (with attachments, HTML formatting)
- Search emails by sender, subject, date range
- Manage folders and move messages
- Mark as read/unread, flag messages
- Delete messages

### Calendar Operations
- Read calendar events
- Create/update/delete events
- Check availability
- Manage meeting invitations
- Support for recurring events
- Time zone handling

### Contact Operations
- Read contacts and contact folders
- Create/update/delete contacts
- Search contacts by name, email, company
- Manage contact groups
- Sync contact information

## Quick Start - Multi-Account

### Add Your First Account

```bash
cd skills/office365-connector

# Add account
node accounts.js add work <tenant-id> <client-id> <client-secret> you@work.com "Work account"

# Authenticate
node auth.js login --account=work
```

### Add More Accounts

```bash
# Add personal account
node accounts.js add personal <tenant> <client> <secret> you@outlook.com "Personal"

# Add consulting account
node accounts.js add consulting <tenant> <client> <secret> you@client.com "Consulting"

# Set default
node accounts.js default work

# List all accounts
node accounts.js list
```

### Use Your Accounts

```bash
# Check work calendar
node calendar.js today --account=work

# Read personal emails
node email.js recent 10 --account=personal

# Send from consulting account
node send-email.js send client@example.com "Subject" "Body" --account=consulting
```

### Migrate from Single-Account Setup

Already using v1.0.0? No problem!

```bash
# Import your existing setup
node accounts.js import-legacy

# Continue using without changes (environment variables still work)
# OR add additional accounts
node accounts.js add secondary <tenant> <client> <secret>
```

## Prerequisites

Before using this skill, you **must** complete the Azure App Registration setup to obtain:

1. **Tenant ID** - Your Azure AD tenant identifier
2. **Client ID** - Your application (client) ID
3. **Client Secret** - Your application secret value

**Setup time: ~10-15 minutes per account**

See [Setup Guide](references/setup-guide.md) for complete step-by-step instructions.

## Permission Validation

This skill requires the following **delegated permissions** (user consent required):

### Email Permissions
- `Mail.Read` - Read user email
- `Mail.ReadWrite` - Read and write access to user email
- `Mail.Send` - Send email as the user

### Calendar Permissions
- `Calendars.Read` - Read user calendars
- `Calendars.ReadWrite` - Read and write access to user calendars

### Contact Permissions
- `Contacts.Read` - Read user contacts
- `Contacts.ReadWrite` - Read and write access to user contacts

### Profile Permissions (required for authentication)
- `User.Read` - Sign in and read user profile
- `offline_access` - Maintain access to data (refresh tokens)

**IMPORTANT:** Before proceeding with setup, confirm that you understand and approve these permissions. Each permission grants specific access to your Microsoft 365 data.

See [Permissions Reference](references/permissions.md) for detailed information about what each permission allows.

## Configuration

### Multi-Account Configuration (v2.0.0+)

Accounts are stored in `~/.openclaw/auth/office365-accounts.json` with tokens in `~/.openclaw/auth/office365/`.

Use the `accounts.js` CLI to manage:

```bash
node accounts.js list                # List all accounts
node accounts.js add <name> ...      # Add account
node accounts.js remove <name>       # Remove account
node accounts.js default <name>      # Set default
```

### Legacy Single-Account (Backward Compatible)

Environment variables still work for single-account use:

```bash
export AZURE_TENANT_ID="your-tenant-id"
export AZURE_CLIENT_ID="your-client-id"
export AZURE_CLIENT_SECRET="your-client-secret"
```

Or in OpenClaw config:

```json
{
  "env": {
    "vars": {
      "AZURE_TENANT_ID": "your-tenant-id",
      "AZURE_CLIENT_ID": "your-client-id",
      "AZURE_CLIENT_SECRET": "your-client-secret"
    }
  }
}
```

## Authentication Flow

This skill uses **OAuth 2.0 Device Code Flow** for resilient authentication:

1. Request device code from Microsoft
2. Display user code and verification URL
3. User visits URL and enters code
4. Poll for token completion
5. Store access + refresh tokens (per-account)
6. Automatically refresh tokens when expired

**Token storage:** Tokens are securely stored in `~/.openclaw/auth/office365/<account-name>.json` with mode 0600 (owner read/write only).

## Usage Examples

### Multi-Account Email Operations

```bash
# Read from default account
node email.js recent 10

# Read from specific account
node email.js recent 10 --account=work

# Search in consulting account
node email.js search "proposal" --account=consulting

# Send from appropriate identity
node send-email.js send client@example.com "Update" "..." --account=consulting
```

### Multi-Account Calendar Operations

```bash
# Check work calendar
node calendar.js today --account=work

# Check personal calendar
node calendar.js week --account=personal
```

### Account Management

```bash
# List all configured accounts
node accounts.js list

# Check authentication status
node auth.js status --account=work

# Re-authenticate if needed
node auth.js login --account=work
```

## Real-World Use Cases

### Multiple Work Identities

Perfect when working across multiple organizations:

```bash
# Morning: Check all calendars
node calendar.js today --account=work
node calendar.js today --account=consulting
node calendar.js today --account=startup

# Process emails by identity
node email.js recent --account=work
node email.js recent --account=consulting

# Send from appropriate account
node send-email.js send client@bigcorp.com "Proposal" "..." --account=work
```

### Personal + Professional Separation

```bash
# Work hours: Work account
node calendar.js today --account=work
node email.js recent --account=work

# After hours: Personal account
node email.js recent --account=personal
```

## Error Handling

The skill includes robust error handling for:

- **Token expiration** - Automatic refresh with exponential backoff
- **Rate limiting** - Retry logic with appropriate delays
- **Network errors** - Connection timeout handling
- **Permission errors** - Clear messages about missing scopes
- **API errors** - Detailed error messages from Microsoft Graph
- **Account not found** - Helpful error messages with suggestions

## Rate Limits

Microsoft Graph API has rate limits:

- **Per-app limit**: 130,000 requests per hour
- **Per-user limit**: Variable based on workload
- **Throttling**: 429 status code triggers automatic retry

The skill automatically handles throttling with exponential backoff.

## Security Considerations

1. **Token Security**: Tokens stored with restricted file permissions (0600)
2. **Per-Account Isolation**: Each account has separate token storage
3. **Scope Limitation**: Request only the minimum required permissions
4. **Refresh Tokens**: Rotated automatically, old tokens invalidated
5. **Client Secret**: Never logged or exposed; stored with mode 0600
6. **Multi-tenant**: This setup is single-tenant (your organization only)

## Troubleshooting

### Multi-Account Issues

**"No account specified and no default account set"**
```bash
# Set a default account
node accounts.js default work

# Or always specify --account=
node calendar.js today --account=work
```

**"Account not found"**
```bash
# List available accounts
node accounts.js list

# Add the missing account
node accounts.js add <name> <tenant> <client> <secret>
```

**Authentication expired**
```bash
# Check status
node auth.js status --account=work

# Re-authenticate
node auth.js login --account=work
```

### Common Issues

**"AADSTS700016: Application not found in directory"**
- Verify Tenant ID matches your Azure AD tenant
- Ensure app registration wasn't deleted

**"AADSTS65001: User did not consent"**
- Complete the device code flow authentication
- Check Admin Consent if required by organization

**"AADSTS700082: Expired refresh token"**
- Re-authenticate using device code flow
- Check token storage file permissions

**"403 Forbidden"**
- Verify API permissions are granted in Azure
- Check if admin consent is required

See [Setup Guide](references/setup-guide.md) and [MULTI-ACCOUNT.md](MULTI-ACCOUNT.md) for detailed troubleshooting.

## Limitations

- **Attachment size**: Max 4MB per attachment (API limit)
- **Email recipients**: Max 500 recipients per email
- **Calendar events**: Limited to 1,095 days in the future
- **Batch operations**: Max 20 requests per batch

## Command Reference

### Account Management
```bash
node accounts.js list                           # List all accounts
node accounts.js add <name> <tenant> <client> <secret> [email] [desc]
node accounts.js remove <name>                  # Remove account
node accounts.js default <name>                 # Set default
node accounts.js import-legacy                  # Import v1.0.0 setup
```

### Authentication
```bash
node auth.js login [--account=name]            # Authenticate
node auth.js status [--account=name]           # Check status
node auth.js token [--account=name]            # Get access token
```

### Email
```bash
node email.js recent [count] [--account=name]
node email.js search "query" [--account=name]
node email.js from email@domain [--account=name]
node email.js read <id> [--account=name]
```

### Calendar
```bash
node calendar.js today [--account=name]
node calendar.js week [--account=name]
```

### Send & Manage
```bash
node send-email.js send <to> <subject> <body> [--account=name]
node send-email.js reply <message-id> <body> [--account=name]
node cancel-event.js <event-id> [comment] [--account=name]
```

## Resources

### Documentation Files

- [MULTI-ACCOUNT.md](MULTI-ACCOUNT.md) - Complete multi-account usage guide
- [CHANGELOG.md](CHANGELOG.md) - Version history and changes
- [CREDITS.md](CREDITS.md) - Attribution and acknowledgments
- [references/setup-guide.md](references/setup-guide.md) - Azure App Registration walkthrough
- [references/permissions.md](references/permissions.md) - Security and permissions reference

### Microsoft Resources

- **Microsoft Graph API Documentation**: https://learn.microsoft.com/en-us/graph/api/overview
- **Delegated vs Application Permissions**: https://learn.microsoft.com/en-us/graph/auth/auth-concepts
- **Rate Limiting**: https://learn.microsoft.com/en-us/graph/throttling

## Credits

**Original Skill:** office365-connector v1.0.0 from ClawHub Community

**Multi-Account Enhancement (v2.0.0):** Matthew Gordon ([matt@workandthrive.ai](mailto:matt@workandthrive.ai))

Thank you to Matthew Gordon for contributing the multi-account enhancement that makes this skill significantly more useful for consultants, freelancers, and anyone managing multiple work identities!

See [CREDITS.md](CREDITS.md) for complete attribution.

## License

Maintains compatibility with the original skill's licensing. See [CREDITS.md](CREDITS.md) for details.
