import matplotlib.pyplot as plt
import os

def generate_revenue_vs_expense_chart(trends, output_path):
    """
    Generates a bar chart for Monthly Revenue vs Expense.
    
    :param trends: List of dictionaries containing 'month', 'revenue', and 'spending'.
    :param output_path: Path to save the image.
    """
    months = [t['month'] for t in trends]
    revenues = [t['revenue'] for t in trends]
    expenses = [t['spending'] for t in trends]

    x = range(len(months))
    width = 0.35

    fig, ax = plt.subplots(figsize=(12, 6))
    ax.plot(months, revenues, marker='o', label='Revenue', color='green', linewidth=2)
    ax.plot(months, expenses, marker='s', label='Expenses', color='red', linewidth=2)

    ax.set_xlabel('Month')
    ax.set_ylabel('Amount (AED)')
    ax.set_title('Monthly Revenue vs Expenses (Line Chart)')
    ax.set_xticks(x)
    ax.set_xticklabels(months, rotation=45)
    ax.legend()

    plt.tight_layout()
    plt.savefig(output_path)
    plt.close()
    return os.path.abspath(output_path)
