# Objection Handling — Turn Resistance Into Revenue

Overcome buyer objections using proven frameworks. Every objection is a buying signal — they're considering it, they just need clarity.
Sources: Gong.io (AI sales data), Thriving Tech (sales methodology), Feel-Felt-Found framework, consultative selling research.
All outputs go to `workspace/artifacts/`.

## Use when
- A prospect says "it's too expensive" / "I need to think about it" / "not the right time"
- Preparing responses for common objections before a sales call
- Reviewing a lost deal to understand what went wrong
- Training yourself on objection patterns for a specific market
- Writing FAQ sections for sales pages that preemptively handle objections

## Don't use when
- Discovery phase (use client-discovery skill — objections come after you've proposed)
- The prospect is genuinely not a fit (respect the "no" — not every objection should be overcome)
- Internal disagreements (this is for sales, not team conflict)
- Customer support complaints (different context, different tone)

## Negative examples
- "How do I find clients?" → No. That's lead generation, not objection handling.
- "Write me a proposal" → No. Use proposal-writing skill.
- "A customer is angry about our service" → No. That's support/retention, not sales objections.

## Edge cases
- Upwork client pushes back on rate → YES. Price objection framework applies.
- "We already have someone for this" → YES. Competitor objection framework.
- Prospect ghosts after proposal → Borderline. Could be objection (fear) or disinterest. Use the breakup follow-up from cold-outreach skill.

---

## The Mindset Shift

**An objection is NOT a rejection.** It's a request for more information.

When someone says "it's too expensive," they're really saying: "I don't yet see enough value to justify this price." That's a solvable problem.

**The two fatal mistakes:**
1. Getting defensive (arguing, justifying, discounting immediately)
2. Giving up (treating it as a hard no)

**The correct response:** Curiosity. Ask questions. Understand what's behind the objection.

---

## The 5 Objection Categories

Every objection falls into one of these buckets. Diagnose the category first, then apply the framework.

### 1. 💰 Price Objections
*"It's too expensive" / "That's over our budget" / "Can you do it cheaper?"*

**What they really mean:** The perceived value doesn't match the price.

**Framework: Value Reframe**
1. Acknowledge: "I hear you — price matters."
2. Quantify the cost of NOT solving: "What's this problem costing you right now? [Use numbers from discovery]"
3. Reframe as ROI: "So this $149/mo investment saves you $500/mo in missed bookings. That's a 3x return."
4. Offer structure, not discount: "Would it help to start with the core package at $99 and add features later?"

**Never:** Immediately discount. It signals your price wasn't real and trains them to always negotiate.

### 2. ⏰ Timing Objections
*"Not right now" / "Maybe next quarter" / "I need to think about it"*

**What they really mean:** Either no urgency, fear of commitment, or they need someone else's approval.

**Framework: Urgency + Easy Entry**
1. Isolate: "Totally understand. Is it the timing, or is there something about the solution itself?"
2. Quantify delay cost: "Every month without this costs you ~$X. In 3 months that's $Y."
3. Lower the commitment: "What if we started with a 2-week pilot? No long-term commitment."
4. Create a deadline (real): "I have capacity for 2 new clients this month. After that, onboarding moves to [date]."

### 3. 🤔 Need Objections
*"I don't think I need this" / "We're doing fine without it" / "I'll just do it myself"*

**What they really mean:** They don't see the gap between where they are and where they could be.

**Framework: Gap Reveal**
1. Ask: "How are you currently handling [the problem]?"
2. Surface the hidden cost: "How much time does that take you per week?"
3. Paint the alternative: "What would you do with [X extra hours/customers] per week?"
4. Social proof: "[Similar business] said the same thing. Within a month they saw [specific result]."

**The "I'll do it myself" variant:** Respect it, but quantify: "Absolutely. From my experience, building this from scratch takes about [X hours]. At your hourly rate of $Y, that's $Z in your time alone — vs. $[your price] to have it done in [timeframe]."

### 4. 🏢 Trust/Credibility Objections
*"I've never heard of you" / "How do I know this will work?" / "Our last vendor failed"*

**What they really mean:** They're risk-averse and need proof.

**Framework: De-Risk**
1. Acknowledge: "Smart to be cautious. I'd want proof too."
2. Case study: "Here's what we did for [similar client]: [specific result]."
3. Guarantee or pilot: "Let's do a 2-week trial. If you don't see [specific outcome], no charge."
4. Social proof: Reviews, testimonials, portfolio links, ClawHub install counts.

### 5. ⚔️ Competitor Objections
*"We're already using [competitor]" / "Someone quoted us less" / "[Other tool] does this"*

**What they really mean:** They need a reason to switch or choose you specifically.

**Framework: Differentiate**
1. Don't trash the competitor: "They're solid for [thing]. Where clients come to us is [your differentiator]."
2. Ask what's missing: "What's working well with [competitor]? What isn't?"
3. Position your unique value: The thing you do that they can't/don't.
4. If purely price: "We're not the cheapest. We're the most [reliable/comprehensive/fast]. You're comparing [Civic] to [Tesla] — depends what you need."

---

## The Feel-Felt-Found Method

Universal technique that works on almost any objection:

1. **Feel:** "I understand how you feel about [the concern]."
2. **Felt:** "Many of our clients felt the same way initially."
3. **Found:** "What they found was [positive outcome that addressed the concern]."

**Example:**
"I totally get that $149/mo feels like a lot for a solo practice. A lot of our massage therapist clients felt the same way. What they found was that the system paid for itself in the first week by capturing bookings they were previously missing."

**Warning:** Don't use this robotically. It works because it's empathetic, not because it's a formula. Adapt the language to sound natural.

---

## Preemptive Objection Handling

The best objection handling happens BEFORE the objection is raised.

**In proposals:** Include an FAQ section addressing the top 3-4 objections for your market.

**In conversations:** "One thing clients often wonder is [common concern]. Here's how we handle that: [answer]."

**On sales pages:** Dedicate a section to "Common Questions" that are really objections in disguise.

**For our products:**

| Product | Top Objection | Preemptive Response |
|---------|--------------|-------------------|
| Alfred automation | "I can't afford $149/mo" | "Captures 3-5 missed appointments/week = $300-500/mo. Pays for itself week 1." |
| Reef on Gumroad | "Why not just use ChatGPT?" | "ChatGPT is cloud-only and $20/mo forever. The Reef runs locally for $0/mo after setup." |
| Upwork services | "Why should I hire you vs. cheaper devs?" | "Cheaper devs take 3x longer. I deliver working automation in [timeframe], not a project that needs fixing." |
| ClawHub skills | "Why pay when free skills exist?" | "Free skills are generic. These are battle-tested on real revenue projects with proven frameworks." |

---

## When to Walk Away

Not every objection should be overcome. Walk away when:
- The prospect genuinely can't afford it AND the ROI doesn't justify creative pricing
- They're disrespectful of your time or expertise
- The project scope is unclear and they refuse to clarify
- Your gut says this will be a problem client (trust it)
- They want you to prove yourself with extensive free work

**Walking away well:** "It sounds like the timing/budget isn't right for this. No worries — I'm here whenever it makes sense. Would it be okay if I checked in next quarter?"

This preserves the relationship and leaves the door open.

---

## Key Patterns
- Objections cluster: 80% of objections are price or timing
- The first objection is rarely the real one — ask follow-up questions
- Silence after stating your price is powerful — don't fill it
- Discounting immediately trains clients to always negotiate
- A "no" today can become a "yes" in 3-6 months with proper follow-up
