# Contributors

## Nutrigenomics Contributors

This document recognises the contributions of individuals and organisations to the Nutrigenomics project.

---

## Project Leadership

### Founder & Maintainer
- **David de Lorenzo** ([@drdaviddelorenzo](https://github.com/drdaviddelorenzo))
  - GitHub: https://github.com/drdaviddelorenzo
  - Website: https://drdaviddelorenzo.github.io
  - Email: david@drdaviddelorenzo.dev
  - Original conception and design
  - Core analysis engine
  - SNP panel curation
  - Ongoing maintenance and development
  - Role: Project Lead

---

## Development Contributors


- **David de Lorenzo**
  - All initial development

### OpenClaw Adaptation (v0.2.0-openclaw)
- **David de Lorenzo**
  - Architecture redesign for web platform
  - Adapter development
  - Documentation rewrite
  
- **Claude (Anthropic)**
  - AI-assisted code generation
  - Architecture recommendations
  - Documentation improvement
  - Deployment guide creation
  - Status: AI co-developer (acknowledged in code comments)

---

## Scientific & Research Support

### SNP Panel Research & Validation
*Contributors who provided literature review or SNP suggestions*

(To be updated as community contributions accumulate)

---

## Documentation & Translation

### English Documentation
- **David de Lorenzo**
  - User guides, technical documentation
  - API documentation
  - Troubleshooting guides

### Future Translations
- **Spanish**: [Contributor needed]
- **Portuguese**: [Contributor needed]
- **French**: [Contributor needed]
- **Mandarin**: [Contributor needed]

*Interested in translating? Contact david@nutrigenomics.dev*

---

## Testing & Quality Assurance

### Unit Tests & Validation
- **David de Lorenzo**
  - Test suite development
  - Validation against synthetic patients
  - Edge case identification

### Beta Testing
(To be updated with community testers)

---

## Research Use & Feedback

### Studies Using Nutrigenomics
*Your research using this tool? Let us know!*

(Citation and feedback appreciated)

---

## Special Thanks

### Research Communities
- **Nutrigenomics researchers** worldwide for publishing foundational studies
- **GWAS Catalog contributors** for SNP and effect size data
- **ClinVar curators** for variant annotation resources

### Funding & Resources
- *No commercial funding* — Community-driven open science

---

## How to Contribute

We welcome contributions in:

### 1. SNP Panel Enhancements
- Suggest new SNPs with PubMed citations
- Propose updated effect sizes from recent GWAS
- Identify population-specific variants
- Flag outdated or controversial SNPs

**Process**:
1. Open GitHub Issue with your suggestion
2. Include peer-reviewed citations
3. Specify allele frequencies in different populations
4. We'll evaluate and add to panel if appropriate
5. You'll be credited as SNP contributor

### 2. Code & Features
- Bug reports and fixes
- Performance optimisations
- Better error handling
- New input format support
- Integration features

**Process**:
1. Fork the repository
2. Create feature branch
3. Submit pull request with tests
4. We'll review and merge
5. Credit in CHANGELOG

### 3. Documentation
- Translations to other languages
- Improved user guides
- Educational materials
- Video tutorials
- Example reports in different languages

**Process**:
1. Contact david@nutrigenomics.dev
2. Discuss scope and timeline
3. Develop materials
4. Submit for review
5. Credit in documentation

### 4. Research & Integration
- Microbiome data integration
- Metabolomics incorporation
- Longitudinal analysis
- Population-specific models
- Clinical validation studies

**Process**:
1. Email your research proposal
2. Discuss feasibility and scope
3. Collaborate on implementation
4. Co-author research output
5. Credit in appropriate channels

---

## Recognition Levels

### Tier 1: Acknowledged Contributors
- Bug reports and small fixes
- Minor documentation improvements
- Single SNP suggestions
- Recognition: Listed in CHANGELOG and CONTRIBUTORS.md

### Tier 2: Core Contributors
- Multiple significant contributions
- New features or modules
- Substantial documentation
- Language translations
- Recognition: Listed prominently + GitHub profile link + mention in README

### Tier 3: Maintainers
- Ongoing project leadership
- Major features or redesigns
- Regular maintenance and support
- Long-term commitment
- Recognition: Co-maintainer status + decision-making role

---

## Code of Conduct

All contributors are expected to:

✅ **Be respectful** — Treat others with kindness and professionalism
✅ **Be inclusive** — Welcome diverse perspectives and backgrounds
✅ **Be honest** — Acknowledge limitations and mistakes
✅ **Be scientific** — Require evidence and citations for claims
✅ **Respect privacy** — Protect user data and genetic information

Violations may result in:
- Discussion and resolution attempt
- Warning if behavior continues
- Removal from project if serious

---

## Contributor License Agreement

By contributing to Nutrigenomics, you agree that:

1. **Your contributions** are your original work or properly licensed
2. **You grant** a perpetual, worldwide license under the MIT License
3. **You understand** the MIT License terms fully
4. **You will not** submit contributions violating third-party rights

For significant contributions, we may ask for a formal CLA (Contributor License Agreement).

---

## Attribution Format

When code/ideas are used, please acknowledge:

### For code contributions:
```python
# Feature: [Name]
# Contributed by: [GitHub username]
# Reference: [GitHub PR/Issue number]
# License: MIT
```

### For SNP suggestions:
```json
{
  "rs_id": "rs123456",
  "gene": "GENE_NAME",
  "suggested_by": "GitHub username",
  "reference": "PubMed ID: XXXXXXX",
  "date_suggested": "YYYY-MM-DD"
}
```

### For documentation:
```markdown
This section was contributed by [Name] ([GitHub username])
Citation: [Appropriate reference]
Date: YYYY-MM-DD
```

---

## Recognition Timeline


- **February 2025** — David de Lorenzo

### v0.2.0-openclaw (OpenClaw Adaptation)
- **February 2026** — David de Lorenzo
- **February 2026** — Claude (Anthropic) — AI co-developer for adaptation

### v0.2.x (Community Maintenance Phase)
*Contributors added as pull requests are merged*

### v0.3.0+ (Feature Releases)
*Major contributors from community will be invited to co-author*

---

## Getting Your Name Here

1. **Find an issue** you'd like to work on
2. **Comment** on the issue to let us know
3. **Submit your contribution** (PR, SNP suggestion, documentation, etc.)
4. **We'll review** and provide feedback
5. **Once merged**, you'll be added to this file!

---

## Questions About Attribution?

- **Email**: david@nutrigenomics.dev
- **GitHub Issues**: https://github.com/clawbio/nutrigenomics/issues
- **Discussions**: https://github.com/clawbio/nutrigenomics/discussions

---

*Last updated: February 28, 2026*
*Nutrigenomics v0.2.0-openclaw*

**Thank you for making personalised nutrigenomics accessible to everyone! 🧬💚**
