# Attribution & Acknowledgments

## Nutrigenomics — Credits and Recognition

### Author & Maintainer
**David de Lorenzo** ([@drdaviddelorenzo](https://github.com/drdaviddelorenzo))
- **GitHub**: https://github.com/drdaviddelorenzo
- **Website**: https://drdaviddelorenzo.github.io
- **Email**: david@drdaviddelorenzo.dev

**Contributions:**
- Conceptualisation and design
- Core analysis engine development
- SNP panel curation
- OpenClaw platform implementation
- OpenClaw adaptation

### Scientific & Technical Foundation

#### Nutrigenomics Research & Literature
The SNP panel and risk scoring algorithm are informed by peer-reviewed nutrigenomics research. Key data sources include:

**Note**: This skill is educational and research-oriented. For the most current and verified scientific information, users should consult:
- The latest peer-reviewed publications indexed in PubMed
- GWAS Catalog for genetic association studies
- ClinVar for variant interpretations
- Their own healthcare providers for medical decisions

#### Data Sources
- **GWAS Catalog**: Buniello A, MacArthur JAL, Cerezo M, et al. (2019). The NHGRI-EBI GWAS Catalog of published genome-wide association studies, targeted arrays and summary statistics. *Nucleic Acids Research*. 47(D1):D1005-D1012. https://www.ebi.ac.uk/gwas/

- **ClinVar**: Landrum MJ, et al. (2024). ClinVar: improvements in accuracy, accessibility, and use of variant interpretations for clinical genetics. *Human Mutation*. https://www.ncbi.nlm.nih.gov/clinvar/

- **PubMed MEDLINE**: US National Library of Medicine. https://pubmed.ncbi.nlm.nih.gov/

### Platform & Infrastructure


  - Original platform for skill development and testing
  - Infrastructure for skill management
  - Community collaboration features

- **OpenClaw**: Web-accessible AI-powered analysis platform
  - User-friendly interface
  - Scalable deployment
  - Community skill marketplace
  - https://openclaw.ai

### Software & Libraries

- **Python**: Python Software Foundation
- **Pandas**: McKinney W. (2010). Data structures for statistical computing in Python. Proceedings of the 9th Python in Science Conference.
- **NumPy**: Harris CR, Millman KJ, van der Walt SJ, et al. (2020). Array programming with NumPy. *Nature*. 585:357-362.
- **Matplotlib**: Hunter JD. (2007). Matplotlib: A 2D graphics environment. *Computing in Science & Engineering*. 9(3):90-95.
- **Seaborn**: Waskom ML. (2021). Seaborn: statistical data visualization. *Journal of Open Source Software*. 6(60):3021.
- **ReportLab**: ReportLab International Ltd.

### Community & Feedback

Special thanks to:

- **Nutrigenomics researchers** who published the foundational studies
- **OpenClaw development team** for platform support
- **Beta testers** who identified edge cases and improvements

---

## How to Cite This Work

If you use Nutrigenomics in research or educational contexts, please cite it as:

### BibTeX
```bibtex
@software{delorenzo2026nutrigenomics,
  author = {de Lorenzo, David},
  title = {Nutrigenomics: Personalised Nutrition from Genetic Data},
  year = {2026},
  url = {https://github.com/clawbio/nutrigenomics},
  version = {0.2.0},
  license = {MIT}
}
```

### APA Format
de Lorenzo, D. (2026). *Nutrigenomics: Personalised nutrition from genetic data* (Version 0.2.0) [Software]. Retrieved from https://github.com/clawbio/nutrigenomics

### Chicago Format
de Lorenzo, David. "Nutrigenomics: Personalised Nutrition from Genetic Data." Version 0.2.0. Accessed [Date]. https://github.com/clawbio/nutrigenomics.

---

## Research & Educational Use

If you use this tool in:
- **Academic research**: Please cite the work and report results
- **Educational materials**: Attribution appreciated (link back to repository)
- **Health/clinical settings**: Review disclaimer carefully; this is educational analysis only
- **Commercial products**: See MIT License terms (you may use it, but must provide attribution)

---

## How to Contribute & Get Recognition

We welcome contributions! Recognized contributors include:

### SNP Panel Contributions
If you suggest new SNPs based on recent research:
- Submit via GitHub Issues with PubMed citations
- Accepted additions credited in CHANGELOG
- Named contributor in SNP_CONTRIBUTORS.md

### Code Improvements
- Bug fixes and optimisations
- Better error handling
- Performance improvements
- Cross-platform compatibility

### Documentation
- Translations to other languages
- Educational materials
- Example analyses
- Tutorial videos

### Research Integration
- Microbiome integration (16S rRNA)
- Metabolomics data incorporation
- Population-specific variants
- Longitudinal analysis modules

**All contributors will be credited in the CONTRIBUTORS.md file.**

---

## Non-Human AI Contributions

This OpenClaw adaptation involved assistance from **Claude (Anthropic)** for:
- Architecture design for web platform compatibility
- Documentation generation and improvement
- Code structure optimisation
- Testing and validation procedures

Claude's contributions are governed by:
- **Anthropic's terms of service**
- **This project's MIT License**
- **Human oversight by David de Lorenzo**

All code remains under David de Lorenzo's authorship with appropriate acknowledgment of AI-assisted development.

---

## Data Privacy & User Recognition

Users of Nutrigenomics consent to:
- ✅ Their genetic data remains private (local processing only)
- ✅ No personal data collection or storage
- ✅ No tracking or analytics of individual results
- ⚠️ Their feedback may be used to improve the tool (anonymously)

---

## Third-Party Genetic Data

Users providing their own genetic data from:
- **23andMe**: https://www.23andme.com
- **AncestryDNA**: https://www.ancestry.com/dna
- **Other direct-to-consumer tests**: FTDNA, MyHeritage, etc.

**Retain all rights to their genetic data.** Nutrigenomics:
- Does not claim ownership
- Does not upload or store their data
- Does not use it for any purpose beyond their individual analysis
- Can be used independently without account creation

---

## Ethical Considerations

This tool was developed with attention to:

1. **Non-discrimination**: Designed for all ancestries and populations
2. **Informed consent**: Clear disclaimers about limitations
3. **Data autonomy**: Users control their own genetic information
4. **Scientific accuracy**: Evidence-based SNP panel and risk scoring
5. **Accessibility**: Available free and open-source to everyone

---

## Disclaimer of Responsibility

Nutrigenomics is provided "as is" without warranty. The author:
- Does not provide medical advice
- Does not constitute healthcare provider relationship
- Should not replace professional medical/nutritional consultation
- Is educational and research-focused only

Users must:
- Consult qualified healthcare providers for medical decisions
- Use results as starting point for informed discussion, not definitive answers
- Understand genetic risk scores are probabilistic, not diagnostic
- Recognise gene × environment interactions affect individual outcomes

---

## Funding & Support

Nutrigenomics was developed:
- As part of David de Lorenzo's research in personalised nutrition and nutrigenomics

- With support from ongoing health informatics work

**No commercial funding** — This is open-source, community-driven science.

---

## Contact for Attribution Questions

For questions about attribution, licensing, or how to credit this work:
- **Email**: david@nutrigenomics.dev
- **GitHub**: [@drdaviddelorenzo](https://github.com/drdaviddelorenzo)
- **Issue tracker**: https://github.com/clawbio/nutrigenomics/issues

---

## License Summary

**Nutrigenomics is free and open-source under the MIT License.**

You are free to:
✅ Use it (personal, educational, commercial)
✅ Modify it
✅ Distribute it
✅ Use it in your own projects

You must:
📋 Include the MIT License in distributions
📋 Give appropriate credit to David de Lorenzo
📋 Not hold the author liable for any issues

See `LICENSE` file for full legal text.

---

*Last updated: February 28, 2026*
*Nutrigenomics v0.2.0-openclaw*
*Made with science, care, and respect for genetic privacy.*
