#!/bin/bash
# scripts/check_logic.sh
# 检查申请书逻辑框架

echo "=== 国自然申请书逻辑框架检查 ==="
echo ""
echo "请逐一回答以下问题（是/否）："
echo ""

# 问题 1
read -p "1. 立项依据是否清晰提出了科学问题？" q1
if [ "$q1" == "是" ] || [ "$q1" == "y" ]; then
    echo "   ✅ 科学问题明确"
else
    echo "   ⚠️  需要进一步凝练科学问题"
fi

# 问题 2
read -p "2. 研究目标是否明确、可衡量？" q2
if [ "$q2" == "是" ] || [ "$q2" == "y" ]; then
    echo "   ✅ 研究目标清晰"
else
    echo "   ⚠️  研究目标需要更具体"
fi

# 问题 3
read -p "3. 研究内容是否与研究目标紧密对应？" q3
if [ "$q3" == "是" ] || [ "$q3" == "y" ]; then
    echo "   ✅ 内容目标一致"
else
    echo "   ⚠️  研究内容需要调整"
fi

# 问题 4
read -p "4. 技术路线是否可视化（有流程图）？" q4
if [ "$q4" == "是" ] || [ "$q4" == "y" ]; then
    echo "   ✅ 技术路线清晰"
else
    echo "   ⚠️  建议添加技术路线图"
fi

# 问题 5
read -p "5. 研究基础是否展示了与项目相关的前期工作？" q5
if [ "$q5" == "是" ] || [ "$q5" == "y" ]; then
    echo "   ✅ 研究基础充分"
else
    echo "   ⚠️  需要补充预实验数据"
fi

# 问题 6
read -p "6. 科学问题、研究内容、研究方案是否前后呼应？" q6
if [ "$q6" == "是" ] || [ "$q6" == "y" ]; then
    echo "   ✅ 逻辑闭环完整"
else
    echo "   ⚠️  需要加强前后呼应"
fi

echo ""
echo "=== 总结 ==="
echo "如果以上有 2 个或以上⚠️，建议重新梳理逻辑框架"
echo ""
echo "核心逻辑：为什么做 → 做什么 → 怎么做 → 为什么你做"
