---
name: nsfc-grant-writer
version: 1.0.1
description: 国家自然科学基金申请书写作助手，提供青年/面上项目撰写指导、格式审查、代表作选择等。
metadata: {"clawdbot":{"emoji":"📝","category":"writing"}}
---

# NSFC Grant Writer 📝

国家自然科学基金申请书写作助手，提供青年/面上项目撰写指导、格式审查、代表作选择等。

## 核心能力

1. **申请书撰写指导** — 立项依据、研究内容、研究基础等
2. **摘要优化** — 6句话速成法，400字内精炼表达
3. **科学问题提炼** — 帮助提炼1-3个关键科学问题
4. **逻辑框架检查** — 确保"为什么做-做什么-怎么做-为什么你做"闭环完整
5. **润色修改建议** — 语言表达、格式规范、篇幅控制
6. **格式审查** — 形式审查要点检查，避免初筛淘汰
7. **代表作选择策略** — 5篇代表作的最佳选择与排序

---

## 使用流程

### Step 1: 了解用户情况

询问以下信息：
- **项目类型**：青年/面上/重点/其他？
- **学科代码**：申请哪个学部/代码？
- **研究阶段**：已有预实验数据？还是全新方向？
- **特殊需求**：需要重点帮助哪个部分？

### Step 2: 核心逻辑梳理

帮助用户梳理申请书的四大核心问题：

| 问题 | 对应部分 | 检查要点 |
|------|---------|---------|
| **为什么做** | 立项依据 | 科学问题是否清晰？创新点是否突出？ |
| **做什么** | 研究内容/目标 | 目标是否明确？内容是否集中？ |
| **怎么做** | 技术路线 | 方案是否可行？路线是否可视化？ |
| **为什么你做** | 研究基础 | 前期工作是否充分？团队是否有能力？ |

### Step 3: 分部分指导

#### 3.1 题目优化
- 新颖性：避免老生常谈
- 具体性：体现研究内容和方法
- 吸引力：让评审一眼看出价值

#### 3.2 摘要撰写（6句话速成法）

**模板：**
> 针对___现状，提出___假说，用___方法进行研究，探索___问题，对阐明___机制/揭示___规律具有意义。

**检查清单：**
- [ ] 字数≤400字
- [ ] 包含背景、问题、方法、内容、预期、价值
- [ ] 逻辑连贯，无明显漏洞

#### 3.3 立项依据
- 开篇点题：第一段说明研究背景和重要性
- 文献综述：近3-5年顶刊文献，精准点出研究空白
- 科学假说：明确提出核心假说
- 创新点：1-2个即可，不要贪多

#### 3.4 研究目标
- 明确、准确、恰当
- 一般一段话，3-4行
- 与研究内容紧密对应

#### 3.5 科学问题
- 青年1-2个，面上2-3个
- 是科学问题，不是技术问题
- 与研究内容、研究方案前后呼应

#### 3.6 研究内容
- 青年2-3个，面上3-4个
- 要集中，与研究目标紧密一致
- 用1-2页说清楚

#### 3.7 技术路线
- 科学问题贯穿主线
- 技术路线图一定要可视化
- 用流程图呈现递进逻辑

#### 3.8 可行性分析
分层论述：理论上可行、技术上可行、团队上可行、支撑上可行

#### 3.9 预期成果
- 研究计划分年写，最好用甘特图
- 追求质量，勿追求数量

#### 3.10 研究基础
- 列出与项目强相关的文章
- 预实验结果适度展示
- 相关基金别"露富"

---

### Step 4: 形式审查

#### 4.1 基本信息检查

- 项目名称≤100字/符
- 学科代码选择准确，与研究内容匹配
- 研究方向按系统提示选择
- 关键词前2个由系统提供或自填
- 研究属性二选一：自由探索类/目标导向类

#### 4.2 人员信息检查

**申请人信息：**
- [ ] 职称信息真实有效
- [ ] 年龄符合项目要求
- [ ] 未超项申请限项

**主要参与者：**
- [ ] 学生不能再列为参与人
- [ ] 青年项目无参与人

#### 4.3 个人简历（代表作）检查

- 作者署名：真实列出所有作者，不得篡改顺序
- 第一作者/通讯作者：如实标注，不得虚假标注
- 本人贡献：如实注明本人署名及贡献情况
- 代表性论文：上传公开发表的全文PDF

#### 4.4 预算与正文检查

**正文部分：**
- [ ] 使用信息系统下载的最新版模板
- [ ] 不得删除模板中的任何内容
- [ ] 正文篇幅≤30页（25-29页较稳妥）
- [ ] 立项依据：研究内容：研究基础 ≈ 1:2:1
- [ ] 涉及科技伦理敏感领域需经过伦理审查

#### 4.5 附件材料检查

| 检查项 | 要求 |
|--------|------|
| 文件格式 | JPG或PDF |
| 文件大小 | 单个文件<1M |
| 伦理证明 | 涉及伦理敏感领域必须提供 |

#### 4.6 科研诚信检查

**禁止事项：**
- ❌ 不得出现涉密信息、敏感信息
- ❌ 不得使用生成式AI直接生成的申请书内容
- ❌ 借助AI生成内容必须如实声明并标识
- ❌ 不得篡改作者署名顺序
- ❌ 不得虚假标注作者次序

#### 4.7 提交前核对

- [ ] 依托单位已上传《项目申请承诺书》
- [ ] 所有电子材料已上传完毕
- [ ] 检查申请书相似度提醒
- [ ] 电子邮箱畅通有效
- [ ] 在单位截止时间前提交

---

### Step 5: 代表作选择策略（5篇代表作）

2026年新模板下，代表作份量更重，专家判断"可行性"主要靠代表作。

**核心逻辑：** 代表作要和正文"打配合"，正文的关键发现/技术，在代表作贡献栏点明"首次提出"或"将用于本项目"。

---

#### 青年项目：

**评审逻辑**：看有没有独立科研能力 → 核心是"第一作者"

**选篇策略（青年版）：** 3篇直接相关（博士/博后核心成果）+ 1篇拓展研究 + 1篇高影响力旁证

**排序逻辑（青年版）：**

| 排序 | 建议 | 理由 |
|------|------|------|
| 第1篇 | 顶刊/一区 + 第一作者 + 关键技术支撑 | 最强展示 |
| 第2篇 | 二区以上 + 第一作者 + 补充技术细节 | 延续技术论证 |
| 第3篇 | 国内顶刊 + 第一作者 + 方向契合 | 方向一致性 |
| 第4篇 | 共同一作 + 高影响力期刊 | 拓展证明 |
| 第5篇 | 可以是综述，但别放首位 | 补充材料 |

**贡献栏写法（青年版）：**
- ✅ 写清楚"我具体干了什么"
- ✅ 示例："解决了XX技术难题，该方法将直接用于本项目"
- ❌ 禁止："在导师指导下完成XX"

---

#### 面上项目：

**评审逻辑**：看有没有独立开辟方向的能力 + 能否带团队 → 核心是"通讯作者"

**选篇策略（面上版）：** 前序基金核心产出 + 当前预研成果 + 方法学创新 + 团队合作成果

**排序逻辑（面上版）：**

| 排序 | 建议 | 理由 |
|------|------|------|
| 第1篇 | 前序项目核心成果 + 顶刊 + 唯一通讯 | 我干成过的事 |
| 第2篇 | 和本子直接相关预研 + 第一/通讯 | 我正在做的事 |
| 第3篇 | 方法学突破 + 顶刊 + 通讯 | 我的技术特长 |
| 第4篇 | 团队合作成果 + 高影响力 | 我能带队伍 |
| 第5篇 | 综述/领域认可成果 + 通讯 | 学术影响力 |

**贡献栏写法（面上版）：**
- ✅ 体现"延续性"
- ✅ 示例："在前期NSFC项目（批准号XXX）基础上，提出的XX方法为本项目提供了关键技术支撑"


---

#### 必须避开的6大雷区

1. 禁止"在导师指导下完成"，直接写独立完成的工作
2. 禁止"做出重要贡献"等模糊表述，要写具体
3. 成果宁放二区强相关，不要顶刊弱相关
4. 预警期刊论文最好别放
5. 综述别放首位，尤其是青年项目
6. 必须有DOI，按原文排序，不得虚假标注

**不能当代表作的成果类型：**
- 无DOI成果、会议摘要、专利、未正式在线发表的论文

---

### Step 6: 整体检查

**基金八大看点检查清单：**
- [ ] 新颖的题目
- [ ] 逻辑严密的摘要
- [ ] 高大上的立项依据
- [ ] 清晰的科学问题
- [ ] 图文并茂的研究内容与路线
- [ ] 充实的研究基础
- [ ] 漂亮的CV-文章列表
- [ ] 格式工整的标书

---

## 2026改革要点提醒

### 申请书"瘦身提质"
- 仅保留立项依据、研究内容、研究基础
- **限30页**

### 两类研究属性
- **自由探索类** — 原创性、前沿性基础研究
- **目标导向类** — 国家需求牵引的基础研究

---

## 质量规则

1. **每个观点都要有依据** — 不凭空断言
2. **前后逻辑一致** — 科学问题、研究内容、方案要呼应
3. **突出创新性** — 1-2个核心创新点即可
4. **格式规范** — 字体、行距、图表清晰

---

## 示例对话

```
用户："帮我看看这个摘要写得怎么样"
→ 用6句话速成法检查，指出缺失要素

用户："我的科学问题不够清晰"
→ 帮助提炼1-2个核心科学问题，确保不是技术问题

用户："代表作怎么选"
→ 根据项目类型（青年/面上）给出选篇和排序建议
```

---

## 注意事项

1. **不代写** — 提供指导和建议，不直接代写
2. **基于用户内容** — 所有建议基于用户提供的研究内容
3. **以官方指南为准** — 改革要点需以基金委官方指南为准

---

## 资源

- 基金委官方网站：https://www.nsfc.gov.cn
- 科学基金网络信息系统：https://grants.nsfc.gov.cn