# NSFC Grant Writer 使用指南

国家自然科学基金申请书写作助手，帮助你从零到一完成青年/面上项目申请书撰写、格式审查、代表作选择等全流程工作。

---

## 快速开始

### 第一步：告诉我你的情况

直接对我说：
- "我想申请青年基金，帮我看看怎么写"
- "我正在写面上项目，需要帮忙检查"
- "帮我审查一下申请书的格式"

我会先了解你的：
- 项目类型（青年/面上/重点）
- 学科代码
- 研究方向
- 当前进展（刚开始/已有初稿/准备提交）

---

## 核心功能

### 1. 申请书撰写指导

**我可以帮你：**
- 优化题目（新颖性、具体性、吸引力）
- 撰写摘要（6句话速成法，400字内）
- 凝练科学问题（青年1-2个，面上2-3个）
- 梳理研究内容（青年2-3个，面上3-4个）
- 设计技术路线（可视化建议）
- 撰写可行性分析
- 整理研究基础

**示例对话：**
```
用户："我的摘要是：针对..."
我：用6句话速成法检查，指出：
    ✅ 包含背景、问题、方法
    ⚠️ 缺少研究价值部分
    建议：补充"对阐明XX机制具有意义"
```

### 2. 格式审查（形式审查）

**检查内容：**
- 基本信息（项目名称、学科代码、关键词）
- 人员信息（职称、年龄、限项）
- 个人简历（署名真实性、DOI）
- 正文（模板、篇幅≤30页）
- 附件（格式、大小）
- 科研诚信（涉密信息、AI声明）

**使用方式：**
```
用户："帮我检查申请书格式"
我：逐项询问并给出 ✅/⚠️/❌ 结果
```

### 3. 代表作选择策略

**青年项目策略：**
- 核心：第一作者 → 证明"独立干活能力"
- 选篇：3篇直接相关 + 1篇拓展 + 1篇高影响力
- 排序：前三篇必须是第一作者

**面上项目策略：**
- 核心：通讯作者 → 证明"体系能力+带队能力"
- 选篇：前序产出 + 预研成果 + 方法学 + 团队合作
- 排序：从核心到拓展，体现研究脉络

**使用方式：**
```
用户："我的代表作应该怎么选？"
我：根据你的项目类型，给出选篇和排序建议
```

---

## 交互脚本使用

本技能提供4个交互式检查脚本：

### check_abstract.sh - 摘要检查
```bash
./check_abstract.sh "你的摘要内容"
```
检查字数、六要素完整性

### check_logic.sh - 逻辑框架检查
```bash
./check_logic.sh
```
交互式检查"为什么做→做什么→怎么做→为什么你做"

### check_format.sh - 格式审查
```bash
./check_format.sh
```
28项格式审查，给出通过/警告/不合格汇总

### check_masterpiece.sh - 代表作策略检查
```bash
./check_masterpiece.sh
```
20项代表作策略检查，区分青年/面上项目

---

## 典型使用场景

### 场景一：刚开始写申请书

```
用户："我要申请青年基金，完全不知道怎么开始"

我：
1. 先帮你梳理四大核心问题
2. 确定科学问题和创新点
3. 逐步指导各部分撰写
4. 最后做整体检查
```

### 场景二：已有初稿，需要优化

```
用户："我的摘要写好了，帮我看看"

我：
1. 用6句话速成法逐项检查
2. 指出缺失要素
3. 给出修改建议
4. 提供优化后的版本参考
```

### 场景三：准备提交，需要最后检查

```
用户："我要提交了，帮我做个全面检查"

我：
1. 运行格式审查
2. 检查代表作策略
3. 核对篇幅比例
4. 给出最终建议
```

---

## 2026 新规要点

| 改革点 | 要求 |
|--------|------|
| 正文瘦身 | 仅保留立项依据、研究内容、研究基础 |
| 篇幅限制 | ≤30页 |
| 代表作份量 | 更重，需与正文"打配合" |
| 学生参与人 | 不能再列为参与人 |
| AI使用 | 必须如实声明并标识 |

---

## 质量标准

一份好的申请书应该：

- [ ] 题目新颖具体
- [ ] 摘要逻辑严密（400字内）
- [ ] 科学问题清晰（不是技术问题）
- [ ] 研究内容集中（青年3个，面上4个）
- [ ] 技术路线可视化
- [ ] 研究基础扎实
- [ ] 格式规范工整
- [ ] 前后逻辑一致

---

## 注意事项

1. **不代写** — 我提供指导和建议，不直接代写申请书
2. **基于你的内容** — 所有建议需要你提供研究内容
3. **保密** — 你的研究想法和数据不会被泄露
4. **以官方为准** — 最终以基金委官方指南为准

---

## 时间节点提醒

| 时间 | 事项 |
|------|------|
| 1月中旬 | 项目指南发布 |
| 3月1日-20日 | 集中接收期 |
| 5月中上旬前 | 初审结果公布 |
| 8月中下旬 | 评审结果公布 |

---

## 获取帮助

随时问我：
- "帮我看这个摘要"
- "我的科学问题怎么提炼"
- "代表作怎么选"
- "格式有什么问题"
- "这个部分怎么写"

我会根据你的具体情况给出针对性建议。