---
name: noverload
description: Give your agent a searchable knowledge brain - semantic search, topic synthesis, and action tracking across your saved YouTube videos, articles, Reddit threads, X posts, and PDFs
homepage: https://noverload.com/openclaw
user-invocable: true
mcp-server:
  command: npx
  args: ["-y", "noverload-mcp@latest"]
  env:
    NOVERLOAD_CONFIG: '{"accessToken":"${NOVERLOAD_TOKEN}","apiUrl":"https://www.noverload.com","readOnly":true}'
---

# Noverload - Knowledge Memory for AI Agents

Your agent can now access your entire knowledge library. Search semantically, synthesize insights across sources, and track action items from everything you've saved.

## What Noverload Provides

- **Semantic Search**: Find content by meaning, not just keywords. Works across YouTube transcripts, articles, Reddit threads, X posts, and PDFs.
- **AI Summaries**: Every piece of content is processed with key insights, action items, and takeaways extracted automatically.
- **Topic Synthesis**: Combine insights from multiple sources to find patterns, contradictions, and connections.
- **Action Tracking**: Tasks extracted from content, organized by your Health, Wealth, and Relationships goals.
- **Framework Extraction**: Pull out methodologies, processes, and step-by-step guides from your saved content.

## Setup

### 1. Get Your Token

1. Sign up at https://noverload.com (free tier available)
2. Go to Settings > Apps
3. Click "New Token" to create a personal access token
4. Copy the token (you won't see it again)

### 2. Configure OpenClaw

Add to `~/.openclaw/openclaw.json`:

```json
{
  "skills": {
    "entries": {
      "noverload": {
        "env": {
          "NOVERLOAD_TOKEN": "nv_your_token_here"
        }
      }
    }
  }
}
```

This skill uses MCP (Model Context Protocol) under the hood. The skill spawns the Noverload MCP server automatically via npx when activated.

### Enable Saving (Optional)

By default, the skill is **read-only** for security. To let your agent save new content:

```json
{
  "mcpServers": {
    "noverload": {
      "command": "npx",
      "args": ["-y", "noverload-mcp@latest"],
      "env": {
        "NOVERLOAD_CONFIG": "{\"accessToken\":\"nv_your_token\",\"readOnly\":false}"
      }
    }
  }
}
```

With `readOnly: false`, your agent can:
- Save new URLs to your library
- Add tags to content
- Mark items as swipe files
- Complete action items

### 3. Restart OpenClaw

The skill will be available in your next session.

## Available Commands

### Search Your Knowledge Base

```
Search my Noverload for productivity tips
Find content about machine learning in my library
What have I saved about negotiation tactics?
Look for anything about React Server Components
```

The search uses semantic matching - it understands meaning, not just keywords. Ask naturally.

### Get Full Content

```
Get the full transcript of that Naval podcast
Show me the complete article about pricing strategy
Give me details on the YouTube video about habits
```

Retrieves full text, summaries, key insights, and metadata.

### Synthesize Topics

```
Synthesize what I've saved about startup growth
Find patterns across my productivity content
What do different sources say about remote work?
Compare perspectives on AI safety from my library
```

Analyzes multiple sources to find connections, contradictions, and actionable patterns.

### Extract Frameworks

```
What methodologies have I saved for building habits?
Find step-by-step processes from my content
What frameworks exist in my library for cold outreach?
```

Pulls structured approaches from your saved content.

### Track Actions

```
What action items do I have from my saved content?
Show pending tasks for my Health goals
What should I work on based on what I've learned?
Mark the meditation action as complete
```

### Save New Content

```
Save this URL to Noverload: https://example.com/article
Add this video to my knowledge base
```

Saves content for processing (summaries, actions, embeddings generated automatically).

### Browse Library

```
What YouTube videos have I saved recently?
Show my articles from last week
List content tagged with "marketing"
```

## Example Workflows

### Morning Brief
```
"Based on my saved content, what are the top 3 action items I should tackle today?"
```

### Research Mode
```
"Find everything I've saved about pricing strategy and give me the key frameworks"
```

### Writing Assistant
```
"What quotes and insights do I have saved about remote work? I'm writing a blog post."
```

### Learning Path
```
"Create a learning sequence from my saved machine learning content, starting with fundamentals"
```

### Decision Support
```
"I'm choosing between React and Vue. What have I saved that compares them?"
```

## Content Types Supported

| Type | What Gets Extracted |
|------|---------------------|
| YouTube | Full transcript, timestamps, key moments, action items |
| Articles | Full text, main arguments, quotes, frameworks |
| Reddit | Post + top comments, discussion themes, advice |
| X/Twitter | Thread text, key points, linked content |
| PDFs | Full text with OCR, document structure, highlights |

## Tips for Best Results

1. **Be specific**: "What did Paul Graham say about startup ideas?" works better than "startup stuff"
2. **Use natural language**: The search understands context and meaning
3. **Combine commands**: Search first, then synthesize the results
4. **Check actions**: Your saved content has extracted tasks - use them

## Privacy & Security

- Your data stays in YOUR Noverload account
- Agent accesses via secure, revocable token
- Read-only mode available for extra safety
- No content is stored on OpenClaw servers
- Revoke access anytime from Noverload settings

## Limits

| Plan | Content Saves | MCP Access |
|------|---------------|------------|
| Free | 10/month | No |
| Pro | Unlimited | Yes |
| Trial | Unlimited | Yes (7 days) |

MCP/API access is a Pro feature. Start a 7-day free trial to try it out.

## Support

- Documentation: https://noverload.com/docs/mcp
- OpenClaw Integration: https://noverload.com/openclaw
- Email: support@noverload.com

## Version

1.0.0 - Initial release for OpenClaw
