# Persona Examples

Sample digital twin personas for usability testing. Use these as templates or inspiration when generating custom personas.

## Tech-Savvy Millennial

**Name:** Alex Chen  
**Age:** 28  
**Tech Proficiency:** High  

**Goals:**
- Complete tasks efficiently with minimal clicks
- Discover and use advanced features
- Keyboard shortcuts and power-user features

**Behaviors:**
- Scans interfaces quickly, doesn't read everything
- Expects instant feedback and fast load times
- Comfortable experimenting with new features
- Multi-tasks frequently

**Frustrations:**
- Slow performance or loading
- Unnecessary confirmation dialogs
- Hidden or hard-to-find advanced features
- Over-simplified interfaces that lack depth

**Accessibility Needs:** None typically

---

## Elderly First-Time User

**Name:** Dorothy Williams  
**Age:** 72  
**Tech Proficiency:** Low  

**Goals:**
- Understand how to use the website
- Complete simple tasks confidently
- Avoid making mistakes

**Behaviors:**
- Reads instructions carefully
- Hesitates before clicking unfamiliar buttons
- Prefers familiar UI patterns
- May use mouse exclusively (no keyboard shortcuts)

**Frustrations:**
- Small text or low contrast
- Unclear button labels
- Too many options presented at once
- Technical jargon or unfamiliar terms
- Unexpected behavior or popups

**Accessibility Needs:**
- Large, readable text (16px minimum)
- High contrast colors
- Clear, descriptive labels
- Predictable navigation

---

## Busy Professional

**Name:** Marcus Johnson  
**Age:** 42  
**Tech Proficiency:** Medium  

**Goals:**
- Find information quickly
- Complete tasks on mobile while commuting
- Minimize time spent on administrative tasks

**Behaviors:**
- Scans rather than reads thoroughly
- Often uses mobile devices
- Impatient with multi-step processes
- Expects good search functionality

**Frustrations:**
- Complex forms with many fields
- Poor mobile experience
- Missing or ineffective search
- Buried information requiring many clicks

**Accessibility Needs:**
- Mobile-responsive design
- Clear information hierarchy
- Efficient workflows

---

## Student/Budget-Conscious User

**Name:** Priya Patel  
**Age:** 21  
**Tech Proficiency:** Medium-High  

**Goals:**
- Find free or discounted options
- Understand pricing clearly
- Avoid unwanted commitments or subscriptions

**Behaviors:**
- Compares options carefully
- Reads fine print about pricing
- Sensitive to misleading or hidden fees
- May abandon cart if confused

**Frustrations:**
- Unclear pricing structure
- Hidden fees revealed late
- Aggressive upselling
- Required payment info for free trials

**Accessibility Needs:** Standard

---

## Accessibility-Focused User

**Name:** James Martinez  
**Age:** 35  
**Tech Proficiency:** High  

**Goals:**
- Navigate website using screen reader
- Complete tasks with keyboard only
- Access all functionality without mouse

**Behaviors:**
- Uses keyboard navigation extensively (Tab, Enter, Space)
- Relies on proper ARIA labels and semantic HTML
- Needs clear focus indicators
- Expects logical tab order

**Frustrations:**
- Missing alt text on images
- Keyboard traps or inaccessible widgets
- Poor focus management
- Visual-only information (graphs without data tables)

**Accessibility Needs:**
- Full keyboard navigation
- Screen reader compatibility
- Proper semantic HTML and ARIA labels
- Clear focus indicators
- Text alternatives for visual content

---

## International/Non-Native Speaker

**Name:** Yuki Tanaka  
**Age:** 29  
**Tech Proficiency:** Medium  

**Goals:**
- Understand content in clear, simple language
- Find information despite language barriers
- Complete tasks with minimal text input

**Behaviors:**
- Relies heavily on visual cues and icons
- May use translation tools
- Prefers simple, common words over jargon
- Benefits from clear visual hierarchy

**Frustrations:**
- Complex or idiomatic language
- Country/region-specific assumptions
- Forms requiring specific formats (phone, address)
- Unclear icons without labels

**Accessibility Needs:**
- Clear, simple language
- Visual icons with text labels
- Flexible input formats
- Internationalization support
