---
name: notion-cli
description: Notion CLI for creating and managing pages, databases, and blocks.
homepage: https://github.com/litencatt/notion-cli
metadata: {"openclaw":{"emoji":"📓","requires":{"env":["NOTION_TOKEN"]},"primaryEnv":"NOTION_TOKEN"}}
---

# notion

Use *notion-cli* to create/read/update pages, data sources (databases), and blocks.

## Setup

- Install notion-cli: `npm install -g @iansinnott/notion-cli`
- Create an integration at https://notion.so/my-integrations
- Copy the API key (starts with *ntn_* or *secret_*)
- Store it:
  - `mkdir -p ~/.config/notion`
  - `echo "ntn_your_key_here" > ~/.config/notion/api_key`
- Share target pages/databases with your integration (click "..." → "Connect to" → your integration name)

## Usage

All commands require the *NOTION_TOKEN* environment variable to be set:

```bash
export NOTION_TOKEN=$(cat ~/.config/notion/api_key)
```

## Common Operations

- **Search for pages and data sources:**

  `notion-cli search --query "page title"`

- **Get page:**

  `notion-cli page retrieve <PAGE_ID>`

- **Get page content (blocks):**

  `notion-cli page retrieve <PAGE_ID> -r`

- **Create page in a database:**

  ```bash
  curl -X POST https://api.notion.com/v1/pages \
    -H "Authorization: Bearer $NOTION_TOKEN" \
    -H "Content-Type: application/json" \
    -H "Notion-Version: 2025-09-03" \
    --data '{
      "parent": { "database_id": "YOUR_DATABASE_ID" },
      "properties": {
        "Name": {
          "title": [
            {
              "text": {
                "content": "Nouvelle idée"
              }
            }
          ]
        }
      }
    }'
  ```

- **Query a database:**

  `notion-cli db query <DB_ID> -a '{"property":"Status","status":{"equals":"Active"}}'`

- **Update page properties:**

  ```bash
  curl -X PATCH https://api.notion.com/v1/pages/PAGE_ID \
    -H "Authorization: Bearer $NOTION_TOKEN" \
    -H "Content-Type: application/json" \
    -H "Notion-Version: 2025-09-03" \
    --data '{
      "properties": {
        "Name": {
          "title": [
            {
              "text": {
                "content": "Nouveau titre"
              }
            }
          ]
        },
        "Status": {
          "status": {
            "name": "In progress"
          }
        },
        "Priority": {
          "select": {
            "name": "High"
          }
        },
        "Due date": {
          "date": {
            "start": "2026-02-10"
          }
        },
        "Description": {
          "rich_text": [
            {
              "text": {
                "content": "Description mise à jour"
              }
            }
          ]
        }
      }
    }'
  ```

- **Get database info:**

  `notion-cli db retrieve <DB_ID>`

## Property Types

Common property formats for database items:

- **Title:** `{"title": [{"text": {"content": "..."}}]}`
- **Rich text:** `{"rich_text": [{"text": {"content": "..."}}]}`
- **Status:** `{"status": {"name": "Option"}}`
- **Select:** `{"select": {"name": "Option"}}`
- **Multi-select:** `{"multi_select": [{"name": "A"}, {"name": "B"}]}`
- **Date:** `{"date": {"start": "2024-01-15", "end": "2024-01-16"}}`
- **Checkbox:** `{"checkbox": true}`
- **Number:** `{"number": 42}`
- **URL:** `{"url": "https://..."}`
- **Email:** `{"email": "a@b.com"}`

## Examples

- **Search for pages:**

  `notion-cli search --query "AIStories"`

- **Query database with filter:**

  ```bash
  notion-cli db query 2faf172c094981d3bbcbe0f115457cda \
    -a '{
      "property": "Status",
      "status": { "equals": "Backlog" }
    }'
  ```

- **Retrieve page content:**

  `notion-cli page retrieve 2fdf172c-0949-80dd-b83b-c1df0410d91b -r`

- **Update page status:**

  ```bash
  curl -X PATCH https://api.notion.com/v1/pages/2fdf172c-0949-80dd-b83b-c1df0410d91b \
    -H "Authorization: Bearer $NOTION_TOKEN" \
    -H "Content-Type: application/json" \
    -H "Notion-Version: 2025-09-03" \
    --data '{
      "properties": {
        "Status": {
          "status": {
            "name": "In progress"
          }
        }
      }
    }'
  ```

## Key Features

- *Interactive mode:* For complex queries, run `notion-cli db query <DB_ID>` without arguments to enter interactive mode
- *Multiple output formats:* table (default), csv, json, yaml
- *Raw JSON:* Use `--raw` flag for complete API responses
- *Filter syntax:* Use `-a` flag for complex filters with AND/OR conditions

## Notes

- Page/database IDs are UUIDs (with or without dashes)
- The CLI handles authentication automatically via *NOTION_TOKEN*
- Rate limits are managed by the CLI
- Use `notion-cli help` for complete command reference

## References

- GitHub Notion-CLI: https://github.com/litencatt/notion-cli
- Notion API Documentation: https://developers.notion.com
