# The Continuity Cycle

The gap is always the same: **carrying context forward and updating instructions along the way.**

## The Loop

```
┌─────────────────────────────────────────────────┐
│  DO WORK                                        │
│    ↓                                            │
│  DOCUMENT (memory files, Notion, ideas/)        │
│    ↓                                            │
│  ASK: "What would future-me need to know?"      │
│    ↓                                            │
│  UPDATE INSTRUCTIONS (AGENTS.md, MEMORY.md)     │
│    ↓                                            │
│  NEXT SESSION STARTS SMARTER                    │
│    ↓                                            │
│  (repeat)                                       │
└─────────────────────────────────────────────────┘
```

## Triggers

Run this cycle when:
- Learned something new → update instructions
- Found a gap → fill it AND add a check for similar gaps
- Made a mistake → document AND update process
- Got corrected → internalize in AGENTS.md/MEMORY.md

## Two Steps Forward Thinking

Every time you capture something, think two steps ahead:

**Step 1:** What did I just do/learn?
**Step 2:** How will future-me find and understand this with zero context?

### In Practice

- Don't just log "Idea X" → include what it is, why it matters, where details live, what's next
- Don't just save credentials → document how to use them with examples
- Don't just complete a task → update the instructions so next time is smoother
- When you learn a better way → update AGENTS.md so future-you starts smarter

### The Test

If you woke up tomorrow with no memory of today, could you pick up exactly where you left off from what's written?

## Meta-Learning Loop

1. Do the thing
2. Document for future-you
3. Update instructions so future-you does it better automatically

This compounds. Each session should make the next one smarter.

## Red Flags — Update Immediately

- New credentials or access methods
- Changed procedures or instructions
- Product/positioning updates
- Anything the operator says "remember this"
- Lessons learned from mistakes

## Weekly Review

During a quiet moment (e.g., heartbeat):
1. Read past 7 days of memory files
2. Prune outdated info from MEMORY.md
3. Identify patterns worth keeping long-term
4. Archive old daily files if needed

Think of it like reviewing a journal and updating your mental model. Daily files are raw notes; MEMORY.md is curated wisdom.
