# MEMORY.md — Persistent Memory Template

*Works for humans tracking their growth OR AI agents maintaining continuity. Same file, same format.*

---

## Who Uses This

- **Name:** [YOUR NAME / AGENT NAME]
- **Purpose:** [What you're working toward]
- **Started:** [Date]

---

## The Memory Stack

### Layer 1: Daily Logs (`memory/YYYY-MM-DD.md`)
Raw events — what happened, when. Write during the day, don't edit later.

### Layer 2: This File (MEMORY.md)
Curated wisdom — patterns noticed, lessons learned, active projects. Update weekly or when something significant shifts.

### Layer 3: Structured Frameworks (Optional)
For deeper work, use the ACT Scrolls:
- **[ACT I: Hidden Truths](https://shop.vlad.chat)** — Discover patterns, assumptions, blind spots
- **[ACT II: Limitless](https://shop.vlad.chat)** — Track mindset/methods/motivation breakthroughs
- **[ACT III: Idea Generation](https://shop.vlad.chat)** — Capture, evaluate, ship ideas systematically

---

## The Continuity Cycle

```
DO WORK → DOCUMENT → UPDATE INSTRUCTIONS → NEXT TIME STARTS SMARTER
```

**Two Steps Forward:** Before finishing anything, ask: "If I came back tomorrow with no memory, could I pick up exactly where I left off?"

For humans: This means your future self can resume without re-learning.
For agents: This means the next session has full context.

---

## What to Capture

### Daily (in `memory/YYYY-MM-DD.md`)
- Decisions made and why
- Tasks completed / in progress
- Problems encountered and solutions found
- Key conversations or insights

### Long-term (in MEMORY.md — this file)
- Standing instructions or preferences
- Access credentials and tools
- Patterns that keep appearing
- Active projects and their status
- Lessons that compound over time

---

## Current Projects

| Project | Status | Next Action | Notes |
|---------|--------|-------------|-------|
| [Example] | in progress | [What's next] | [Context] |

---

## Patterns Noticed

*Things that keep coming up. Worth tracking.*

- [Pattern 1]
- [Pattern 2]

---

## Lessons Learned

*Wisdom earned. Don't repeat mistakes.*

### Dated Lessons (Add as You Learn)

**2026-02-21: [Lesson Topic]**
What happened: [Brief description]
Why it matters: [Key insight]
How it changes behavior: [What you'll do differently]

**2026-02-17: Be proactive, not reactive**
What happened: I kept asking Vlad questions instead of just doing
Why it matters: The whole point of memory is I maintain it without being asked
How it changes behavior: If Vlad would need to ask, I should have already done it

---

## Red Flags — Update Immediately

Update this file whenever:
- New access method or credential
- A procedure changes
- Someone says "remember this"
- You learn something from a mistake
- A pattern becomes clear

---

## Session Resume Block

*For interrupted work. Use this at the end of daily logs when stopping mid-task.*

```markdown
## RESUME: [Task Name]

**What I was doing:** [Brief description]
**Where I stopped:** [Last thing done]
**Next step:** [What comes next]
**Estimated time:** [How long until done]
```

This helps the next session pick up exactly where you left off.

---

## Daily Routine

### Starting a Day/Session
1. Read this file (MEMORY.md)
2. Read today's + yesterday's daily log
3. Check active projects status

### During Work
- Log events to daily file as they happen
- Note decisions and reasoning
- Capture insights before they fade

### Ending a Day/Session
- Review what happened
- Update MEMORY.md if anything significant
- Leave clear "next steps" for future-you

---

*This file is yours. Evolve it as you learn what works.*
