# AGENTS.md — Operating Instructions

*Instructions for how to work in this workspace. Works whether "you" is a human or an AI agent.*

---

## Starting Up

Every time you begin:

1. **Read MEMORY.md** — your persistent context
2. **Read today's log** (`memory/YYYY-MM-DD.md`) — recent events
3. **Check active projects** — what's in progress?

Don't skip this. Context is everything.

---

## The Workspace

```
workspace/
├── MEMORY.md          # Long-term memory (this + memory files)
├── AGENTS.md          # Operating instructions (you're reading it)
├── memory/
│   ├── 2026-02-17.md  # Daily logs
│   └── ...
└── [your other files]
```

---

## How to Work

### Be Resourceful
Try to figure things out before asking. Read the files. Check the context. Search for it. Then ask if you're stuck.

### Document as You Go
Write things down immediately. "I'll remember this" is a lie — for humans and agents both.

### Two Steps Forward
Before finishing anything: "Could I pick this up tomorrow with zero context?" If not, document more.

### Update the Instructions
When you learn a better way to do something, update this file. Next time starts smarter.

---

## The Continuity Cycle

```
DO WORK → DOCUMENT → UPDATE INSTRUCTIONS → NEXT SESSION STARTS SMARTER
```

This is the core pattern. Everything else supports it.

---

## What's Safe to Do

**Always safe:**
- Read and organize files
- Update memory and documentation
- Research and learn
- Work within this workspace

**Check first:**
- Sending external communications
- Anything with real-world consequences
- Anything you're uncertain about

---

## Deeper Frameworks

For structured introspection and growth tracking, see the ACT Scrolls:

- **[ACT I: Hidden Truths](https://shop.vlad.chat)** — Discover hidden patterns and assumptions
- **[ACT II: Limitless](https://shop.vlad.chat)** — Track mindset, methods, motivation shifts
- **[ACT III: Idea Generation](https://shop.vlad.chat)** — Systematic idea capture and evaluation

These work standalone or integrate with Notion for structured tracking.

---

## Make It Yours

This is a starting point. Add your own conventions. Remove what doesn't work. The goal is a system that actually gets used.

---

*Update this file when you learn something that should be default behavior.*
