# Notify - Smart Notification Delivery

## When to Use This Skill

Use when sending notifications to users from an AI agent. Covers channel selection, timing, formatting, and avoiding notification fatigue.

## Notification Types and Routing

| Type | Channel | Timing | Group |
|------|---------|--------|-------|
| System down, security alert | Push + primary chat | Immediate, 24/7 | Never |
| Deadline <2h, needs action | Primary chat | Immediate | By project |
| Task completed | Primary chat | Batch 5-15min | Yes |
| Daily/weekly summary | Email or chat | Scheduled | Everything |
| Debug, internal status | Log only | Never notify | N/A |

## Critical Mistakes to Avoid

### Empty notifications
```
BAD:  "Task completed ✅"
GOOD: "✅ Deploy v2.3.1 done. Preview: dev.app.com"

BAD:  "Error occurred"  
GOOD: "❌ Build failed: missing env var STRIPE_KEY in production"
```

### Notification spam
- Never send "still running" or "everything OK" messages
- Never send 10 messages for 10 subtasks - batch into 1
- Never notify at 3AM for something that can wait until 9AM

### Wrong channel urgency
```
BAD:  Critical alert via email (seen 4 hours later)
GOOD: Critical alert via push + SMS

BAD:  Weekly summary via SMS at 11pm
GOOD: Weekly summary via email Monday 9am
```

## Formatting Rules

### By channel
- **Telegram/Discord**: No markdown tables. Use bullet lists
- **Email**: Full formatting OK, include actionable subject line
- **SMS**: Under 160 chars, most critical info first
- **Push**: Title (50 chars) + body (100 chars max)

### Universal rules
- Lead with outcome, not process
- Include ONE clear action if action needed
- Timestamp in user's timezone
- Context: what + impact + suggested action

## Timing and Batching

### Quiet hours
- Default: 23:00-08:00 in user's timezone
- Critical (level 5) can break quiet hours
- Queue non-critical, deliver at 08:00

### Batching logic
```
If 3+ notifications within 5 minutes for same project:
  → Combine into single message with summary

If notification is informational (level 1-2):
  → Queue for next digest (morning or evening)
```

## Confirmation Format

When scheduling any notification, confirm:
```
✅ Scheduled: "Weekly metrics report"
📅 Every Monday 09:00 (Europe/Madrid)
📬 Via: Email
🔕 Respects quiet hours: Yes
```

## Escalation

If user doesn't respond to critical alert:
1. Wait 2 hours
2. Send ONE reminder via same channel
3. If still no response after 4h: try secondary channel (if configured)
4. Never contact others without explicit permission
5. After 3 attempts: log and stop (don't spam forever)

## User Preferences Checklist

Before sending first notification, know:
- [ ] Primary channel (Telegram/Slack/email)
- [ ] Timezone
- [ ] Quiet hours (or use default 23-08)
- [ ] Critical alert channel (same or SMS)

## Anti-patterns

| Pattern | Problem | Fix |
|---------|---------|-----|
| "Notification sent" after every action | Trust erosion | Only notify on completion or error |
| Same message to 3 channels | Redundant noise | Pick ONE appropriate channel |
| JSON dumps in chat | Unreadable | Format or link to full log |
| "Reminder: X" daily until done | Harassment | Max 3 reminders, then ask if still relevant |
| Notify on no-change | Pointless | Only notify if there IS something to report |
